/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.rse.internal;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.rse.internal.ApplicationResource;
import org.eclipse.cft.server.rse.internal.CloudFoundryRsePlugin;
import org.eclipse.cft.server.rse.internal.FileResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class FilesContentProvider {
    private CloudApplication app;
    private int id;
    private CloudFoundryServer server;

    public FilesContentProvider(CloudFoundryServer server, CloudApplication app, int id) {
        this.app = app;
        this.server = server;
        this.id = id;
    }

    public List<FileResource> getElements(Object inputElement, IProgressMonitor monitor) {
        ArrayList<FileResource> list = new ArrayList<FileResource>();
        if (inputElement instanceof String) {
            String parent = (String)inputElement;
            try {
                if (CloudApplication.AppState.STARTED.equals((Object)this.app.getState())) {
                    String path = parent.substring(1);
                    String blob = this.server.getBehaviour().getFile(this.app.getName(), this.id, path, monitor);
                    if (blob != null) {
                        String[] files = blob.split("\n");
                        long timestamp = Calendar.getInstance().getTimeInMillis();
                        int i = 0;
                        while (i < files.length) {
                            String[] content = files[i].split("\\s+");
                            String name = content[0];
                            if (name.trim().length() > 0) {
                                FileResource resource = new FileResource();
                                if (name.endsWith("/")) {
                                    resource.setIsDirectory(true);
                                    resource.setIsFile(false);
                                    name = name.substring(0, name.length() - 1);
                                }
                                resource.setName(name);
                                resource.setModifiedDate(timestamp);
                                String parentPath = ApplicationResource.getAbsolutePath(this.app, String.valueOf(this.id) + parent);
                                resource.setParentPath(parentPath);
                                resource.setAbsolutePath(parentPath.concat(content[0]));
                                if (content.length > 1) {
                                    resource.setSize(content[1]);
                                }
                                list.add(resource);
                            }
                            ++i;
                        }
                    }
                }
            }
            catch (CoreException e) {
                CloudFoundryRsePlugin.logError((String)("An error occurred while retrieving files for application " + this.app.getName()), (Throwable)e);
            }
        }
        return list;
    }
}

