/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.cloudfoundry.client.lib.CloudCredentials;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.spaces.CloudOrgsAndSpaces;
import org.eclipse.cft.server.ui.internal.CloudFoundryServerUiPlugin;
import org.eclipse.cft.server.ui.internal.CloudServerUIUtil;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.springframework.web.client.ResourceAccessException;

public class CloudUiUtil {
    public static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    public static String ATTR_USER_DEFINED_URLS = "org.eclipse.cft.server.user.defined.urls";

    public static IStatus runForked(final ICoreRunnable coreRunner, IWizard wizard) {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            wizard.getContainer().run(true, false, runner);
        }
        catch (InvocationTargetException e) {
            Status status = e.getCause() instanceof CoreException ? new Status(4, "org.eclipse.cft.server.ui", NLS.bind((String)Messages.CloudUiUtil_ERROR_FORK_OP_FAILED, (Object)e.getCause().getMessage()), (Throwable)e) : new Status(4, "org.eclipse.cft.server.ui", NLS.bind((String)Messages.CloudUiUtil_ERROR_FORK_UNEXPECTED, (Object)e.getMessage()), (Throwable)e);
            CloudFoundryServerUiPlugin.getDefault().getLog().log((IStatus)status);
            IWizardPage page = wizard.getContainer().getCurrentPage();
            if (page instanceof DialogPage) {
                ((DialogPage)page).setErrorMessage(status.getMessage());
            }
            return status;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private static CloudFoundryBrandingExtensionPoint.CloudServerURL convertAbstractCloudFoundryUrlToCloudServerURL(AbstractCloudFoundryUrl abstractUrl) {
        CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl = null;
        if (abstractUrl != null) {
            cloudUrl = abstractUrl instanceof CloudFoundryBrandingExtensionPoint.CloudServerURL ? (CloudFoundryBrandingExtensionPoint.CloudServerURL)abstractUrl : new CloudFoundryBrandingExtensionPoint.CloudServerURL(abstractUrl.getName(), abstractUrl.getUrl(), abstractUrl.getUserDefined(), abstractUrl.getSignUpUrl(), abstractUrl.getSelfSigned());
        }
        return cloudUrl;
    }

    private static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> convertAbstractCloudFoundryUrlListToCloudServerURLList(List<AbstractCloudFoundryUrl> abstractUrls) {
        if (abstractUrls == null) {
            return null;
        }
        ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL> urls = new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        for (AbstractCloudFoundryUrl abstractUrl : abstractUrls) {
            if (abstractUrl == null) continue;
            urls.add(CloudUiUtil.convertAbstractCloudFoundryUrlToCloudServerURL(abstractUrl));
        }
        return urls;
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getAllUrls(String serverTypeId) {
        try {
            return CloudUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getAllUrls(serverTypeId, null));
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
            return new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        }
    }

    public static CloudFoundryBrandingExtensionPoint.CloudServerURL getDefaultUrl(String serverTypeId) {
        CloudFoundryBrandingExtensionPoint.CloudServerURL url = null;
        try {
            AbstractCloudFoundryUrl abstractUrl = CloudServerUIUtil.getDefaultUrl(serverTypeId, null);
            if (abstractUrl != null) {
                url = CloudUiUtil.convertAbstractCloudFoundryUrlToCloudServerURL(abstractUrl);
            }
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
        }
        return url;
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getUrls(String serverTypeId) {
        try {
            return CloudUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getUrls(serverTypeId, null));
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
            return new ArrayList<CloudFoundryBrandingExtensionPoint.CloudServerURL>();
        }
    }

    public static List<CloudFoundryBrandingExtensionPoint.CloudServerURL> getUserDefinedUrls(String serverTypeId) {
        return CloudUiUtil.convertAbstractCloudFoundryUrlListToCloudServerURLList(CloudServerUIUtil.getUserDefinedUrls(serverTypeId));
    }

    public static void storeUserDefinedUrls(String serverTypeId, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> urls) {
        if (urls == null) {
            return;
        }
        ArrayList<AbstractCloudFoundryUrl> abstractUrls = new ArrayList<AbstractCloudFoundryUrl>();
        for (CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl : urls) {
            abstractUrls.add((AbstractCloudFoundryUrl)cloudUrl);
        }
        CloudServerUIUtil.storeUserDefinedUrls(serverTypeId, abstractUrls);
    }

    public static void validateCredentials(final String userName, final String password, final String urlText, final boolean displayURL, final boolean selfSigned, IRunnableContext context) throws CoreException, OperationCanceledException {
        try {
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    String url = urlText;
                    if (displayURL) {
                        url = CloudUiUtil.getUrlFromDisplayText(urlText);
                    }
                    CloudFoundryServerBehaviour.validate((String)url, (String)userName, (String)password, (boolean)selfSigned, (IProgressMonitor)monitor);
                }
            };
            if (context != null) {
                CloudUiUtil.runForked(coreRunner, context);
            } else {
                CloudUiUtil.runForked(coreRunner);
            }
        }
        catch (CoreException ce) {
            if (ce.getCause() instanceof ResourceAccessException && ce.getCause().getCause() instanceof SSLPeerUnverifiedException) {
                throw CloudErrorUtil.toCoreException((Throwable)ce.getCause().getCause());
            }
            throw ce;
        }
    }

    public static CloudOrgsAndSpaces getCloudSpaces(final String userName, final String password, final String urlText, final boolean displayURL, final boolean selfSigned, IRunnableContext context) throws CoreException {
        try {
            final CloudOrgsAndSpaces[] supportsSpaces = new CloudOrgsAndSpaces[1];
            ICoreRunnable coreRunner = new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    String url = urlText;
                    if (displayURL) {
                        url = CloudUiUtil.getUrlFromDisplayText(urlText);
                    }
                    supportsSpaces[0] = CloudFoundryServerBehaviour.getCloudSpacesExternalClient((CloudCredentials)new CloudCredentials(userName, password), (String)url, (boolean)selfSigned, (IProgressMonitor)monitor);
                }
            };
            if (context != null) {
                CloudUiUtil.runForked(coreRunner, context);
            } else {
                CloudUiUtil.runForked(coreRunner);
            }
            return supportsSpaces[0];
        }
        catch (OperationCanceledException e) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus((Throwable)e));
        }
    }

    public static String getUrlFromDisplayText(String displayText) {
        int pos;
        String url = displayText;
        if (url != null && (pos = url.lastIndexOf(" - ")) >= 0) {
            return url.substring(pos + 3);
        }
        return url;
    }

    public static String getDisplayTextFromUrl(String url, String serverTypeId) {
        try {
            List<AbstractCloudFoundryUrl> cloudUrls = CloudServerUIUtil.getAllUrls(serverTypeId, null);
            for (AbstractCloudFoundryUrl cloudUrl : cloudUrls) {
                if (!cloudUrl.getUrl().equals(url)) continue;
                return String.valueOf(cloudUrl.getName()) + " - " + url;
            }
        }
        catch (CoreException ex) {
            CloudFoundryServerUiPlugin.logError(ex);
        }
        return url;
    }

    public static void runForked(ICoreRunnable coreRunner) throws OperationCanceledException, CoreException {
        CloudUiUtil.runForked(coreRunner, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public static void runForked(final ICoreRunnable coreRunner, IRunnableContext progressService) throws OperationCanceledException, CoreException {
        try {
            IRunnableWithProgress runner = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("", -1);
                    try {
                        try {
                            coreRunner.run(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            progressService.run(true, true, runner);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                throw (CoreException)e.getCause();
            }
            CloudFoundryServerUiPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.cft.server.ui", "Unexpected exception", (Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public static void openUrl(String location) {
        CloudUiUtil.openUrl(location, WebBrowserPreference.getBrowserChoice());
    }

    public static void openUrl(String location, int browserChoice) {
        try {
            URL url = null;
            if (location != null) {
                url = new URL(location);
            }
            if (browserChoice == 1) {
                try {
                    IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                    support.getExternalBrowser().openURL(url);
                }
                catch (Exception exception) {}
            } else {
                int flags = WorkbenchBrowserSupport.getInstance().isInternalWebBrowserAvailable() ? 38 : 134;
                String generatedId = "org.eclipse.mylyn.web.browser-" + Calendar.getInstance().getTimeInMillis();
                IWebBrowser browser = WorkbenchBrowserSupport.getInstance().createBrowser(flags, generatedId, null, null);
                browser.openURL(url);
            }
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_BODY);
        }
        catch (MalformedURLException malformedURLException) {
            if (location == null || location.trim().equals("")) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)NLS.bind((String)Messages.CloudUiUtil_ERROR_EMPTY_URL_BODY, (Object)location));
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.CloudUiUtil_ERROR_OPEN_BROWSER_FAIL_TITLE, (String)NLS.bind((String)Messages.CloudUiUtil_ERROR_MALFORM_URL_BODY, (Object)location));
        }
    }

    public static CloudFoundryBrandingExtensionPoint.CloudServerURL getWildcardUrl(CloudFoundryBrandingExtensionPoint.CloudServerURL cloudUrl, List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls, Shell shell) {
        AbstractCloudFoundryUrl returnUrl;
        ArrayList<AbstractCloudFoundryUrl> allCloudFoundryUrls = new ArrayList<AbstractCloudFoundryUrl>();
        if (allCloudUrls != null) {
            for (CloudFoundryBrandingExtensionPoint.CloudServerURL _cloudUrl : allCloudUrls) {
                allCloudFoundryUrls.add((AbstractCloudFoundryUrl)_cloudUrl);
            }
        }
        if ((returnUrl = CloudServerUIUtil.getWildcardUrl((AbstractCloudFoundryUrl)cloudUrl, allCloudFoundryUrls, shell)) != null) {
            return new CloudFoundryBrandingExtensionPoint.CloudServerURL(returnUrl.getName(), returnUrl.getUrl(), true, returnUrl.getSelfSigned());
        }
        return null;
    }

    public static IStructuredSelection getServersViewSelection() {
        IViewReference[] references;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow;
        String serversViewID;
        IViewRegistry registry = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor serversViewDescriptor = registry.find(serversViewID = SERVERS_VIEW_ID);
        if (serversViewDescriptor != null && (activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (references = activePage.getViewReferences()) != null) {
            ISelection selection;
            ISelectionProvider selectionProvider;
            IViewSite viewSite;
            IViewPart serversViewPart = null;
            IViewReference[] iViewReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference reference = iViewReferenceArray[n2];
                if (serversViewID.equals(reference.getId())) {
                    serversViewPart = reference.getView(true);
                    break;
                }
                ++n2;
            }
            if (serversViewPart != null && (viewSite = serversViewPart.getViewSite()) != null && (selectionProvider = viewSite.getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection) {
                return (IStructuredSelection)selection;
            }
        }
        return null;
    }

    public static Shell getShell() {
        return PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
    }
}

