/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudApplicationURL;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.UIPart;
import org.eclipse.cft.server.ui.internal.wizards.CloudUIEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CloudApplicationUrlPart
extends UIPart {
    protected final ApplicationUrlLookupService lookupService;
    private String currentUrl;
    private Control validationSource;
    private Text subDomainText;
    private Text fullURLText;
    private Combo domainCombo;

    public CloudApplicationUrlPart(ApplicationUrlLookupService lookupService) {
        this.lookupService = lookupService;
    }

    public Composite createPart(Composite parent) {
        Composite subDomainComp = parent;
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(subDomainComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)subDomainComp);
        Label label = new Label(subDomainComp, 0);
        label.setText(Messages.CloudApplicationUrlPart_TEXT_SUBDOMAIN_LABEL);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.subDomainText = new Text(subDomainComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.subDomainText);
        this.subDomainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CloudApplicationUrlPart.this.resolveUrlFromSubdomain((Control)CloudApplicationUrlPart.this.subDomainText);
            }
        });
        label = new Label(subDomainComp, 0);
        label.setText(Messages.COMMONTXT_DOMAIN);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.domainCombo = new Combo(subDomainComp, 2056);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.domainCombo);
        this.domainCombo.setEnabled(true);
        this.domainCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CloudApplicationUrlPart.this.resolveUrlFromSubdomain((Control)CloudApplicationUrlPart.this.domainCombo);
            }
        });
        label = new Label(subDomainComp, 0);
        label.setText(Messages.CloudApplicationUrlPart_TEXT_DEPLOYURL_LABEL);
        GridDataFactory.fillDefaults().grab(false, false).align(4, 0x1000000).applyTo((Control)label);
        this.fullURLText = new Text(subDomainComp, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fullURLText);
        this.fullURLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CloudApplicationUrlPart.this.currentUrl = CloudApplicationUrlPart.this.fullURLText.getText();
                CloudApplicationUrlPart.this.validate(null, (Control)CloudApplicationUrlPart.this.fullURLText);
            }
        });
        return subDomainComp;
    }

    public String getCurrentDomain() {
        if (this.isActive((Control)this.domainCombo)) {
            int selectionIndex = this.domainCombo.getSelectionIndex();
            String[] domains = this.domainCombo.getItems();
            if (selectionIndex >= 0 && selectionIndex < domains.length) {
                return domains[selectionIndex];
            }
        }
        return null;
    }

    public void refreshDomains() {
        if (this.isActive((Control)this.domainCombo)) {
            String existingSelection = this.getCurrentDomain();
            List<String> domains = this.getDomains();
            this.domainCombo.setItems(domains.toArray(new String[0]));
            this.updateDomainSelection(existingSelection);
        }
    }

    public void setUrl(String url) {
        this.currentUrl = url;
        this.setTextValue(this.fullURLText, this.currentUrl);
    }

    public void setSubdomain(String subdomain) {
        this.setTextValue(this.subDomainText, subdomain);
    }

    protected void setTextValue(Text textControl, String value) {
        if (value == null) {
            value = "";
        }
        if (this.isActive((Control)textControl) && !textControl.getText().equals(value)) {
            textControl.setText(value);
        }
    }

    protected void resolveUrlFromSubdomain(Control source) {
        String subdomain = this.subDomainText.getText();
        String domain = this.getCurrentDomain();
        CloudApplicationURL suggestedUrl = new CloudApplicationURL(subdomain, domain);
        this.validate(suggestedUrl, source);
    }

    protected boolean isActive(Control control) {
        return control != null && !control.isDisposed();
    }

    protected void validate(CloudApplicationURL appUrl, Control source) {
        if (this.validationSource != null) {
            return;
        }
        this.validationSource = source;
        IStatus status = Status.OK_STATUS;
        if (appUrl == null) {
            if (this.currentUrl != null) {
                try {
                    appUrl = this.lookupService.getCloudApplicationURL(this.currentUrl);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                }
            }
        } else {
            try {
                appUrl = this.lookupService.validateCloudApplicationUrl(appUrl);
            }
            catch (CoreException ce) {
                status = ce.getStatus();
            }
        }
        if (appUrl != null) {
            this.currentUrl = appUrl.getUrl();
        }
        if (this.validationSource != this.fullURLText) {
            this.setTextValue(this.fullURLText, this.currentUrl);
        }
        if (this.validationSource != this.domainCombo) {
            String domain = appUrl != null ? appUrl.getDomain() : null;
            this.updateDomainSelection(domain);
        }
        if (this.validationSource != this.subDomainText) {
            String subDomain = appUrl != null ? appUrl.getSubdomain() : null;
            this.setTextValue(this.subDomainText, subDomain);
        }
        this.validationSource = null;
        this.notifyChange(new PartChangeEvent(this.currentUrl, status, CloudUIEvent.APPLICATION_URL_CHANGED));
    }

    protected List<String> getDomains() {
        ArrayList<String> domains = new ArrayList<String>();
        List cloudDomains = this.lookupService.getDomains();
        if (cloudDomains != null) {
            for (CloudDomain cldm : cloudDomains) {
                domains.add(cldm.getName());
            }
        }
        return domains;
    }

    protected void updateDomainSelection(String domain) {
        if (this.isActive((Control)this.domainCombo)) {
            int selectionIndex;
            List<String> domains;
            if (this.getSelectionIndex(domain) < 0 && this.getCurrentDomain() == null && !(domains = this.getDomains()).isEmpty()) {
                domain = domains.get(0);
            }
            if (domain != null && (selectionIndex = this.getSelectionIndex(domain)) > -1) {
                this.domainCombo.select(selectionIndex);
            }
        }
    }

    protected int getSelectionIndex(String domain) {
        int selectionIndex = -1;
        String[] domains = this.domainCombo.getItems();
        if (domains != null) {
            int i = 0;
            while (i < domains.length) {
                if (domains[i].equals(domain)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
        }
        return selectionIndex;
    }
}

