/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationAction;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDescriptor;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardRegistry;
import org.eclipse.cft.server.ui.internal.wizards.IApplicationWizardDelegate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CloudFoundryApplicationWizard
extends Wizard {
    protected final CloudFoundryApplicationModule module;
    protected final CloudFoundryServer server;
    protected IApplicationWizardDelegate wizardDelegate;
    protected final ApplicationWizardDescriptor applicationDescriptor;
    protected DeploymentInfoWorkingCopy workingCopy;

    public CloudFoundryApplicationWizard(CloudFoundryServer server, CloudFoundryApplicationModule module, DeploymentInfoWorkingCopy workingCopy, IApplicationWizardDelegate wizardDelegate) {
        Assert.isNotNull((Object)server);
        Assert.isNotNull((Object)module);
        Assert.isNotNull((Object)workingCopy);
        this.server = server;
        this.module = module;
        this.wizardDelegate = wizardDelegate;
        this.workingCopy = workingCopy;
        this.applicationDescriptor = new ApplicationWizardDescriptor((ApplicationDeploymentInfo)this.workingCopy);
        this.applicationDescriptor.setApplicationStartMode(ApplicationAction.START);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.CloudFoundryApplicationWizard_TITLE_APP);
    }

    public void addPages() {
        List<IWizardPage> applicationDeploymentPages = null;
        if (this.wizardDelegate == null) {
            this.wizardDelegate = ApplicationWizardRegistry.getDefaultJavaWebWizardDelegate();
        }
        if ((applicationDeploymentPages = this.wizardDelegate.getWizardPages(this.applicationDescriptor, this.server, this.module)) != null && !applicationDeploymentPages.isEmpty()) {
            for (IWizardPage updatedPage : applicationDeploymentPages) {
                this.addPage(updatedPage);
            }
        } else {
            String moduleID = this.module != null && this.module.getModuleType() != null ? this.module.getModuleType().getId() : "Unknown module type.";
            CloudFoundryPlugin.logError((String)("No application deployment wizard pages found for application type: " + moduleID + ". Unable to complete application deployment. Check that the application type is registered in the Cloud Foundry application framework."));
        }
    }

    public List<CloudService> getCloudServicesToCreate() {
        return this.applicationDescriptor.getCloudServicesToCreate();
    }

    public boolean persistManifestChanges() {
        return this.applicationDescriptor.shouldPersistDeploymentInfo();
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        if (this.applicationDescriptor.getApplicationStartMode() != null) {
            return new DeploymentConfiguration(this.applicationDescriptor.getApplicationStartMode());
        }
        return null;
    }

    public boolean performFinish() {
        this.workingCopy.save();
        return true;
    }
}

