/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerEvent;
import org.eclipse.cft.server.core.internal.CloudServerListener;
import org.eclipse.cft.server.core.internal.ServerEventHandler;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.CloudRefreshEvent;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.EditorAction;
import org.eclipse.cft.server.ui.internal.actions.RefreshEditorAction;
import org.eclipse.cft.server.ui.internal.editor.ApplicationMasterDetailsBlock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.ui.editor.ServerEditorPart;

public class CloudFoundryApplicationsEditorPage
extends ServerEditorPart {
    private CloudFoundryServer cloudServer;
    private ApplicationMasterDetailsBlock masterDetailsBlock;
    private ManagedForm mform;
    private ServerListener serverListener;
    private final List<CloudServerListener> cloudServerListeners = new ArrayList<CloudServerListener>();
    private List<CloudService> services;
    private ScrolledForm sform;
    private int[] applicationMemoryChoices;
    private final int MAX_ERROR_MESSAGE = 100;
    private UIJob refreshJob;
    private RefreshEditorOperation currentRefreshOp;

    public void createPartControl(Composite parent) {
        this.mform = new ManagedForm(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.sform = this.mform.getForm();
        this.sform.getForm().setText(Messages.COMMONTXT_APPLICATIONS);
        toolkit.decorateFormHeading(this.sform.getForm());
        this.cloudServer = (CloudFoundryServer)this.getServer().getOriginal().loadAdapter(CloudFoundryServer.class, null);
        this.masterDetailsBlock = new ApplicationMasterDetailsBlock(this, this.cloudServer);
        this.masterDetailsBlock.createContent((IManagedForm)this.mform);
        this.sform.getForm().setImage(CloudFoundryImages.getImage(CloudFoundryImages.OBJ_APPLICATION));
        this.refresh(EditorAction.RefreshArea.MASTER);
        this.serverListener = new ServerListener();
        this.addCloudServerListener(this.serverListener);
        this.getServer().getOriginal().addServerListener((IServerListener)this.serverListener);
    }

    public void addCloudServerListener(CloudServerListener listener) {
        if (listener != null && !this.cloudServerListeners.contains(listener)) {
            ServerEventHandler.getDefault().addServerListener(listener);
            this.cloudServerListeners.add(listener);
        }
    }

    public void dispose() {
        for (CloudServerListener listener : this.cloudServerListeners) {
            ServerEventHandler.getDefault().removeServerListener(listener);
        }
        this.getServer().getOriginal().removeServerListener((IServerListener)this.serverListener);
        if (this.mform != null) {
            this.mform.dispose();
            this.mform = null;
        }
        super.dispose();
    }

    public CloudFoundryServer getCloudServer() {
        return this.cloudServer;
    }

    public ApplicationMasterDetailsBlock getMasterDetailsBlock() {
        return this.masterDetailsBlock;
    }

    public List<CloudService> getServices() {
        return this.services;
    }

    public int[] getApplicationMemoryChoices() {
        return this.applicationMemoryChoices;
    }

    public boolean isDisposed() {
        return this.sform.isDisposed();
    }

    public void reflow() {
        this.mform.getForm().reflow(true);
    }

    public void refresh(EditorAction.RefreshArea area) {
        RefreshEditorAction.getRefreshAction(this, area).run();
    }

    public void selectAndReveal(IModule module) {
        this.masterDetailsBlock.refreshUI(EditorAction.RefreshArea.MASTER);
        TableViewer viewer = this.masterDetailsBlock.getMasterPart().getApplicationsViewer();
        viewer.setSelection((ISelection)new StructuredSelection((Object)module));
        this.refresh(EditorAction.RefreshArea.DETAIL);
    }

    public void setFocus() {
    }

    public void setMessage(String message, int messageType) {
        String messageToDisplay = message;
        if (messageToDisplay == null) {
            this.sform.setMessage(null, 0);
        } else {
            StringBuffer buffer = new StringBuffer(messageToDisplay);
            int i = 0;
            while (i < buffer.length()) {
                char ch = buffer.charAt(i);
                if (ch == '\r' || ch == '\n') {
                    buffer.replace(i, i + 1, " ");
                }
                ++i;
            }
            if (buffer.length() > 100) {
                String endingSegment = Messages.CloudFoundryApplicationsEditorPage_TEXT_SEE_ERRORLOG;
                messageToDisplay = String.valueOf(buffer.substring(0, 100).trim()) + endingSegment;
                CloudFoundryPlugin.logError((String)message);
            } else {
                messageToDisplay = buffer.toString();
            }
            this.sform.setMessage(messageToDisplay, messageType);
        }
    }

    public void setServices(List<CloudService> services) {
        this.services = services;
    }

    public void setApplicationMemoryChoices(int[] applicationMemoryChoices) {
        this.applicationMemoryChoices = applicationMemoryChoices;
    }

    private synchronized void setRefreshOp(RefreshEditorOperation op) {
        this.currentRefreshOp = op;
    }

    private synchronized RefreshEditorOperation getRefreshOp() {
        return this.currentRefreshOp;
    }

    protected void launchRefresh(RefreshEditorOperation refreshOp) {
        this.setRefreshOp(refreshOp);
        if (this.refreshJob == null) {
            this.refreshJob = new UIJob(Messages.CloudFoundryApplicationsEditorPage_JOB_REFRESH){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    RefreshEditorOperation op = CloudFoundryApplicationsEditorPage.this.getRefreshOp();
                    if (op != null) {
                        op.run(monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        this.refreshJob.schedule();
    }

    protected void setMessageInPage(IStatus status) {
        String message;
        String string = message = status != null ? status.getMessage() : null;
        if (message == null || status == null || status.isOK()) {
            this.setMessage(null, 0);
        } else {
            int providerStatus = 0;
            switch (status.getSeverity()) {
                case 1: {
                    providerStatus = 1;
                    break;
                }
                case 2: {
                    providerStatus = 2;
                    break;
                }
                case 4: {
                    providerStatus = 3;
                }
            }
            this.setMessage(message, providerStatus);
        }
    }

    private class RefreshEditorOperation {
        private CloudServerEvent event;
        private final EditorAction.RefreshArea area;
        private final int type;
        private final IStatus status;

        public RefreshEditorOperation(CloudServerEvent event, EditorAction.RefreshArea area) {
            this.event = event;
            this.area = area;
            this.type = event.getType();
            this.status = event.getStatus() != null ? event.getStatus() : Status.OK_STATUS;
        }

        public RefreshEditorOperation(int eventType, EditorAction.RefreshArea area, IStatus status) {
            this.area = area;
            this.type = eventType;
            this.status = status != null ? status : Status.OK_STATUS;
        }

        public void run(IProgressMonitor monitor) {
            if (CloudFoundryApplicationsEditorPage.this.isDisposed() || CloudFoundryApplicationsEditorPage.this.mform == null || CloudFoundryApplicationsEditorPage.this.mform.getForm() == null || CloudFoundryApplicationsEditorPage.this.mform.getForm().isDisposed() || CloudFoundryApplicationsEditorPage.this.masterDetailsBlock.getMasterPart().getManagedForm().getForm().isDisposed()) {
                return;
            }
            if (this.event instanceof CloudRefreshEvent && (this.type == 200 || this.type == 400) && this.status.getSeverity() != 4) {
                List<CloudService> services = ((CloudRefreshEvent)this.event).getServices();
                if (services == null) {
                    services = Collections.emptyList();
                }
                CloudFoundryApplicationsEditorPage.this.setServices(services);
            }
            Throwable error = this.status.getException();
            CloudFoundryApplicationsEditorPage.this.masterDetailsBlock.refreshUI(this.area);
            if (this.status.getSeverity() == 2 || this.status.getSeverity() == 1) {
                CloudFoundryApplicationsEditorPage.this.setMessageInPage(this.status);
            } else if (error != null || this.status.getSeverity() == 4) {
                StatusManager.getManager().handle(this.status, 1);
                CloudFoundryApplicationsEditorPage.this.setMessageInPage(this.status);
            } else {
                CloudFoundryApplicationModule appModule;
                IModule currentModule = CloudFoundryApplicationsEditorPage.this.getMasterDetailsBlock().getCurrentModule();
                IStatus status = null;
                if (currentModule != null && (appModule = CloudFoundryApplicationsEditorPage.this.getCloudServer().getExistingCloudModule(currentModule)) != null) {
                    status = appModule.getStatus();
                }
                CloudFoundryApplicationsEditorPage.this.setMessageInPage(status);
            }
        }
    }

    private class ServerListener
    implements CloudServerListener,
    IServerListener {
        private ServerListener() {
        }

        public void serverChanged(CloudServerEvent event) {
            if (event.getServer() == null) {
                CloudFoundryPlugin.logError((String)"Internal error: unable to refresh editor. No Cloud server specified in the server event.");
                return;
            }
            if (!CloudFoundryApplicationsEditorPage.this.cloudServer.getServer().getId().equals(event.getServer().getServer().getId())) {
                return;
            }
            if (event.getType() != 100) {
                EditorAction.RefreshArea area = event instanceof EditorAction.EditorCloudEvent ? ((EditorAction.EditorCloudEvent)event).getRefreshArea() : EditorAction.RefreshArea.ALL;
                CloudFoundryApplicationsEditorPage.this.launchRefresh(new RefreshEditorOperation(event, area));
            }
        }

        public void serverChanged(ServerEvent event) {
            if (event.getKind() == 16) {
                CloudFoundryApplicationsEditorPage.this.launchRefresh(new RefreshEditorOperation(400, EditorAction.RefreshArea.ALL, event.getStatus()));
            }
        }
    }
}

