/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.comma.monitoring.lib.CComponentConstraintMonitor;
import org.eclipse.comma.monitoring.lib.CComponentConstraintResult;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraint;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintContext;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintError;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintMonitorResult;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintResult;
import org.eclipse.comma.monitoring.lib.CFunctionalConstraintState;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;
import org.eclipse.comma.monitoring.lib.utils.CTraceSerializer;
import org.eclipse.comma.monitoring.lib.utils.Utils;

public class CFunctionalConstraintMonitor
extends CComponentConstraintMonitor {
    private CComponentMonitoringContext context;
    private CFunctionalConstraint constraint;
    private Function<CObservedMessage, Boolean> filter;
    private List<CFunctionalConstraintContext> componentExecutionContexts = new ArrayList<CFunctionalConstraintContext>();
    private CTraceSerializer traceSerializer;
    private boolean inErrorState;
    private CFunctionalConstraintMonitorResult funcConstraintResult;
    private CComponentConstraintResult result;

    public CFunctionalConstraintMonitor(CComponentMonitoringContext context, CFunctionalConstraint constraint, Function<CObservedMessage, Boolean> filter) {
        this.context = context;
        this.constraint = constraint;
        this.filter = filter;
        this.inErrorState = false;
        CFunctionalConstraintContext initialContext = new CFunctionalConstraintContext();
        initialContext.setConstraintExecutionStates(Arrays.asList(constraint.getInitialState()));
        initialContext.setInitialPortsStates(constraint.getInitialState().getInitialPortStates());
        this.componentExecutionContexts.add(initialContext);
        String traceFile = context.getTraceFile(constraint.getName());
        this.traceSerializer = new CTraceSerializer(traceFile);
        this.funcConstraintResult = new CFunctionalConstraintMonitorResult(constraint.getName(), traceFile);
        this.result = new CComponentConstraintResult();
        this.result.addFunctionaConstraintResult(this.funcConstraintResult);
    }

    @Override
    public void consume(CObservedMessage message, List<CPathDescription> pathDescriptions, String port) throws Exception {
        if (this.inErrorState) {
            return;
        }
        this.updateExecutionStates(message, pathDescriptions, port);
        if (this.componentExecutionContexts.isEmpty()) {
            if (this.filter.apply(message).booleanValue()) {
                this.traceSerializer.processEvent(message);
            }
            this.handleError();
            return;
        }
        if (this.filter.apply(message).booleanValue()) {
            this.traceSerializer.processEvent(message);
            ArrayList<CFunctionalConstraintContext> newComponentExecutionContexts = new ArrayList<CFunctionalConstraintContext>();
            for (CFunctionalConstraintContext context : this.componentExecutionContexts) {
                this.constraint.setPortsContext(context);
                ArrayList<CFunctionalConstraintState> newStates = new ArrayList<CFunctionalConstraintState>();
                for (CFunctionalConstraintState state : context.getConstraintExecutionStates()) {
                    this.constraint.setState(state);
                    CFunctionalConstraintResult result = this.constraint.consume(message);
                    newStates.addAll(result.states);
                }
                if (newStates.isEmpty()) continue;
                context.setConstraintExecutionStates(newStates);
                newComponentExecutionContexts.add(context);
            }
            if (newComponentExecutionContexts.isEmpty()) {
                this.handleError();
            } else {
                this.componentExecutionContexts = newComponentExecutionContexts;
            }
        }
    }

    private void handleError() {
        this.inErrorState = true;
        CFunctionalConstraintError error = new CFunctionalConstraintError();
        error.setErrorContext(this.traceSerializer.getLatestTrace());
        String umlErrorFileName = this.context.getErrorUMLFile(this.constraint.getName());
        error.setUMLFile(umlErrorFileName);
        this.funcConstraintResult.setError(error);
        try {
            FileWriter writer = new FileWriter(this.context.getResultsFile(this.constraint.getName()), false);
            writer.write(this.funcConstraintResult.toString());
            writer.close();
            FileWriter umlWriter = new FileWriter(umlErrorFileName, false);
            umlWriter.write(error.toUML());
            umlWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateExecutionStates(CObservedMessage message, List<CPathDescription> pathDescriptions, String port) {
        String connection = "";
        String instanceName = this.context.getComponentInstanceName();
        connection = message.getDestination().equals(instanceName) ? message.getSource() : message.getDestination();
        ArrayList<CFunctionalConstraintContext> newComponentExecutionContexts = new ArrayList<CFunctionalConstraintContext>();
        for (CFunctionalConstraintContext executionContext : this.componentExecutionContexts) {
            CFunctionalConstraintContext newExecutionContext;
            Map<String, CPathDescription> portConnections = executionContext.getPortsStates().get(port);
            if (portConnections == null) {
                for (CPathDescription pd : pathDescriptions) {
                    newExecutionContext = (CFunctionalConstraintContext)Utils.deepCopy(executionContext);
                    HashMap<String, CPathDescription> connections = new HashMap<String, CPathDescription>();
                    connections.put(connection, (CPathDescription)Utils.deepCopy(pd));
                    newExecutionContext.getPortsStates().put(port, connections);
                    newComponentExecutionContexts.add(newExecutionContext);
                }
                continue;
            }
            if (!portConnections.containsKey(connection)) {
                for (CPathDescription pd : pathDescriptions) {
                    if (!this.context.isSingletonPort(port)) {
                        newExecutionContext = (CFunctionalConstraintContext)Utils.deepCopy(executionContext);
                        newExecutionContext.getPortsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                        newComponentExecutionContexts.add(newExecutionContext);
                        continue;
                    }
                    newExecutionContext = (CFunctionalConstraintContext)Utils.deepCopy(executionContext);
                    newExecutionContext.getPortsStates().get(port).entrySet().forEach(p -> {
                        CPathDescription cPathDescription2 = p.setValue((CPathDescription)Utils.deepCopy(pd));
                    });
                    newExecutionContext.getPortsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                    newComponentExecutionContexts.add(newExecutionContext);
                }
                continue;
            }
            for (CPathDescription pd : pathDescriptions) {
                String path = portConnections.get(connection).getPathId();
                if (!pd.getPathId().startsWith(path)) continue;
                CFunctionalConstraintContext newExecutionContext2 = (CFunctionalConstraintContext)Utils.deepCopy(executionContext);
                newExecutionContext2.getPortsStates().get(port).put(connection, (CPathDescription)Utils.deepCopy(pd));
                newComponentExecutionContexts.add(newExecutionContext2);
                if (!this.context.isSingletonPort(port)) continue;
                newExecutionContext2.getPortsStates().get(port).entrySet().forEach(p -> {
                    CPathDescription cPathDescription2 = p.setValue((CPathDescription)Utils.deepCopy(pd));
                });
            }
        }
        this.componentExecutionContexts = newComponentExecutionContexts;
    }

    @Override
    public CComponentConstraintResult getResults() {
        return this.result;
    }

    @Override
    public void traceEnded() {
        if (!this.inErrorState) {
            try {
                FileWriter writer = new FileWriter(this.context.getResultsFile(this.constraint.getName()), false);
                writer.write(this.funcConstraintResult.toString());
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

