/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.handler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.IScriptEngineProvider;
import org.eclipse.ease.Logger;
import org.eclipse.ease.Script;
import org.eclipse.ease.service.EngineDescription;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.ScriptEditorInput;
import org.eclipse.ease.ui.dialogs.SelectScriptStorageDialog;
import org.eclipse.ease.ui.handler.ToggleHandler;
import org.eclipse.ease.ui.preferences.PreferencesHelper;
import org.eclipse.ease.ui.scripts.ScriptStorage;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.tools.StringTools;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.menus.UIElement;

public class ToggleScriptRecording
extends ToggleHandler
implements IHandler,
IElementUpdater,
IExecutionListener {
    private boolean fChecked = false;
    private static final Map<IScriptEngine, StringBuffer> fRecordings = new HashMap<IScriptEngine, StringBuffer>();

    @Override
    protected final void executeToggle(ExecutionEvent event, boolean checked) {
        IScriptEngine engine;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof IScriptEngineProvider && (engine = ((IScriptEngineProvider)part).getScriptEngine()) != null) {
            if (checked) {
                fRecordings.put(engine, new StringBuffer());
                engine.addExecutionListener((IExecutionListener)this);
            } else {
                StringBuffer buffer = fRecordings.get(engine);
                if (buffer.length() > 0) {
                    InputDialog dialog;
                    String name = "recorded script";
                    final ScriptStorage storage = this.getStorage();
                    if (storage != null && (dialog = new InputDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Save Script", "Enter a unique name for your script (use '/' as path delimiter)", "", new IInputValidator(){

                        public String isValid(String name) {
                            if (storage.exists(name)) {
                                return "Script name <" + name + "> is already in use. Choose a different one.";
                            }
                            return null;
                        }
                    })).open() == 0) {
                        name = dialog.getValue();
                    }
                    EngineDescription description = engine.getDescription();
                    ScriptType scriptType = (ScriptType)description.getSupportedScriptTypes().iterator().next();
                    String fileName = String.valueOf(name) + "." + scriptType.getDefaultExtension();
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("name", new Path(name).makeRelative().toString());
                    header.put("description", "Script recorded by user.");
                    header.put("script-type", scriptType.getName());
                    header.put("author", System.getProperty("user.name"));
                    header.put("date-recorded", new SimpleDateFormat("yyyy-MM-dd, HH:mm").format(new Date()));
                    buffer.insert(0, "\n");
                    buffer.insert(0, scriptType.getHeaderParser().createHeader(header));
                    if (storage != null) {
                        if (!storage.store(fileName, buffer.toString())) {
                            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Save error", (String)"Could not store script data");
                        }
                    } else {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            IEditorDescriptor editor = IDE.getDefaultEditor((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("/sample/foo." + scriptType.getDefaultExtension())));
                            IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)new ScriptEditorInput(name, buffer.toString()), (String)editor.getId());
                            openEditor.doSaveAs();
                        }
                        catch (PartInitException e) {
                            Logger.logError((String)"Could not open editor for recorded script.", (Throwable)e);
                        }
                    }
                }
            }
        }
        this.fChecked = checked;
    }

    private ScriptStorage getStorage() {
        if (PreferencesHelper.getUserScriptStorageLocation() == null) {
            SelectScriptStorageDialog dialog = new SelectScriptStorageDialog(Display.getDefault().getActiveShell());
            if (dialog.open() == 0) {
                PreferencesHelper.addLocation(dialog.getLocation(), true, true);
                IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
                repositoryService.updateLocations();
            } else {
                return null;
            }
        }
        return ScriptStorage.createStorage();
    }

    @Override
    public final void updateElement(UIElement element, Map parameters) {
        super.updateElement(element, parameters);
        if (this.fChecked) {
            element.setIcon(Activator.getImageDescriptor("org.eclipse.ease.ui", "icons/elcl16/stop_script_recording.png"));
        } else {
            element.setIcon(Activator.getImageDescriptor("org.eclipse.ease.ui", "icons/elcl16/start_script_recording.png"));
        }
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (4 == status) {
            try {
                StringBuffer buffer = fRecordings.get(engine);
                if (buffer != null) {
                    buffer.append(script.getCode());
                    buffer.append(StringTools.LINE_DELIMITER);
                } else {
                    engine.removeExecutionListener((IExecutionListener)this);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (CoreException coreException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

