/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class ModuleHelp {
    private static IMemento getHelpContent(ModuleDefinition definition) {
        if (definition != null) {
            String helpLocation = definition.getHelpLocation(null);
            URL url = PlatformUI.getWorkbench().getHelpSystem().resolve(helpLocation, true);
            try {
                XMLMemento rootNode = XMLMemento.createReadRoot((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                return rootNode.getChild("body");
            }
            catch (Exception e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot find the module help content ", (Throwable)e);
            }
        }
        return null;
    }

    private static String getCSSUrl(ModuleDefinition definition) {
        String helpLocation = definition.getHelpLocation(null);
        URL url = PlatformUI.getWorkbench().getHelpSystem().resolve(helpLocation, true);
        return url.toString().replace(helpLocation, "/org.eclipse.ease.help/help/css/tooltip.css");
    }

    public static String getModuleHelpTip(ModuleDefinition definition) {
        StringBuilder helpContent = new StringBuilder();
        IMemento bodyNode = ModuleHelp.getHelpContent(definition);
        if (bodyNode != null) {
            helpContent.append("<head><link rel=\"stylesheet\" type=\"text/css\" href=\"");
            helpContent.append(ModuleHelp.getCSSUrl(definition));
            helpContent.append("\" /></head><body>");
            IMemento[] iMementoArray = bodyNode.getChildren();
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if (node.getTextData().equalsIgnoreCase("Method Overview") || node.getTextData().equalsIgnoreCase("Constants")) break;
                helpContent.append(node);
                ++n2;
            }
            helpContent.append("</body>");
        }
        return helpContent.toString();
    }

    public static String getMethodHelpTip(Method method) {
        StringBuilder helpContent = new StringBuilder();
        IMemento bodyNode = ModuleHelp.getHelpContent(ModulesTools.getDeclaringModule(method));
        if (bodyNode != null) {
            IMemento[] iMementoArray = bodyNode.getChildren("div");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if (method.getName().equals(node.getString("title")) && "command".equals(node.getString("class"))) {
                    helpContent.append("<head><link rel=\"stylesheet\" type=\"text/css\" href=\"");
                    helpContent.append(ModuleHelp.getCSSUrl(ModulesTools.getDeclaringModule(method)));
                    helpContent.append("\" /></head><body>");
                    helpContent.append(node);
                    helpContent.append("</body>");
                    break;
                }
                ++n2;
            }
        }
        return helpContent.toString();
    }

    public static String getConstantHelpTip(Field field) {
        StringBuilder helpContent = new StringBuilder();
        IMemento bodyNode = ModuleHelp.getHelpContent(ModulesTools.getDeclaringModule(field));
        if (bodyNode != null) {
            IMemento[] iMementoArray = bodyNode.getChildren("table");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if ("constants".equals(node.getString("class"))) {
                    IMemento[] iMementoArray2 = node.getChildren("tr");
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento tableRow = iMementoArray2[n4];
                        boolean found = false;
                        IMemento[] iMementoArray3 = tableRow.getChildren("td");
                        int n5 = iMementoArray3.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IMemento tableCell = iMementoArray3[n6];
                            if (found) {
                                helpContent.append("<head><link rel=\"stylesheet\" type=\"text/css\" href=\"");
                                helpContent.append(ModuleHelp.getCSSUrl(ModulesTools.getDeclaringModule(field)));
                                helpContent.append("\" /></head><body>");
                                helpContent.append(tableCell.getTextData());
                                helpContent.append("</body>");
                                return helpContent.toString();
                            }
                            IMemento anchorNode = tableCell.getChild("a");
                            found = anchorNode != null && field.getName().equals(anchorNode.getString("id"));
                            ++n6;
                        }
                        ++n4;
                    }
                    break;
                }
                ++n2;
            }
        }
        return helpContent.toString();
    }
}

