/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.ui.Activator;
import org.eclipse.ease.ui.modules.ui.ModulesTools;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;

public class ModuleHelp {
    private static final Map<String, String> CACHED_IMAGES = new HashMap<String, String>();

    private static String getImageLocation(String bundlePath) {
        InputStream input;
        if (!CACHED_IMAGES.containsKey(bundlePath) && (input = Activator.getResource(bundlePath)) != null) {
            try {
                File tempFile = File.createTempFile("EASE_image", "png");
                tempFile.deleteOnExit();
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(tempFile));
                BufferedInputStream inputStream = new BufferedInputStream(input);
                byte[] buffer = new byte[1024];
                int bytes = ((InputStream)inputStream).read(buffer);
                while (bytes != -1) {
                    ((OutputStream)outputStream).write(buffer, 0, bytes);
                    bytes = ((InputStream)inputStream).read(buffer);
                }
                ((InputStream)inputStream).close();
                ((OutputStream)outputStream).close();
                CACHED_IMAGES.put(bundlePath, tempFile.toURI().toString());
            }
            catch (FileNotFoundException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot find image file for help hover", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot create image file for help hover", (Throwable)e);
                return null;
            }
        }
        return CACHED_IMAGES.get(bundlePath);
    }

    private static IMemento getHelpContent(ModuleDefinition definition) {
        if (definition != null) {
            String helpLocation = definition.getHelpLocation(null);
            URL url = PlatformUI.getWorkbench().getHelpSystem().resolve(helpLocation, true);
            try {
                XMLMemento rootNode = XMLMemento.createReadRoot((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                return rootNode.getChild("body");
            }
            catch (Exception e) {
                Logger.error((String)"org.eclipse.ease.ui", (String)"Cannot find the module help content ", (Throwable)e);
            }
        }
        return null;
    }

    public static String getModuleHelpTip(ModuleDefinition definition) {
        IMemento bodyNode = ModuleHelp.getHelpContent(definition);
        if (bodyNode != null) {
            StringBuffer helpContent = new StringBuffer();
            IMemento[] iMementoArray = bodyNode.getChildren();
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if ("module".equals(node.getString("class"))) {
                    IMemento[] iMementoArray2 = node.getChildren();
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String content;
                        IMemento contentNode = iMementoArray2[n4];
                        if ("description".equals(contentNode.getString("class")) && (content = ModuleHelp.getNodeContent(contentNode)) != null && !content.isEmpty()) {
                            helpContent.append(content);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (helpContent.length() > 0) {
                StringBuffer help = new StringBuffer();
                HTMLPrinter.addSmallHeader((StringBuffer)help, (String)ModuleHelp.getImageAndLabel(ModuleHelp.getImageLocation("icons/eobj16/module.png"), definition.getName()));
                help.append("<br />");
                help.append(helpContent);
                return help.toString();
            }
        }
        return null;
    }

    public static String getImageAndLabel(String imageSrcPath, String label) {
        StringBuffer buf = new StringBuffer();
        int imageWidth = 16;
        int imageHeight = 16;
        int labelLeft = 20;
        int labelTop = 2;
        buf.append("<div style='word-wrap: break-word; position: relative; ");
        if (imageSrcPath != null) {
            buf.append("margin-left: ").append(20).append("px; ");
            buf.append("padding-top: ").append(2).append("px; ");
        }
        buf.append("'>");
        if (imageSrcPath != null) {
            StringBuffer imageStyle = new StringBuffer("border:none; position: absolute; ");
            imageStyle.append("width: ").append(16).append("px; ");
            imageStyle.append("height: ").append(16).append("px; ");
            imageStyle.append("left: ").append(-21).append("px; ");
            buf.append("<!--[if lte IE 6]><![if gte IE 5.5]>\n");
            String tooltip = "";
            buf.append("<span ").append("").append("style=\"").append(imageStyle).append("filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src='").append(imageSrcPath).append("')\"></span>\n");
            buf.append("<![endif]><![endif]-->\n");
            buf.append("<!--[if !IE]>-->\n");
            buf.append("<img ").append("").append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<!--<![endif]-->\n");
            buf.append("<!--[if gte IE 7]>\n");
            buf.append("<img ").append("").append("style='").append(imageStyle).append("' src='").append(imageSrcPath).append("'/>\n");
            buf.append("<![endif]-->\n");
        }
        buf.append(label);
        buf.append("</div>");
        return buf.toString();
    }

    public static String createLink(String uri, String label) {
        return "<a class='header' href='" + uri + "'>" + label + "</a>";
    }

    /*
     * WARNING - void declaration
     */
    public static String getMethodHelpTip(Method method) {
        IMemento bodyNode = ModuleHelp.getHelpContent(ModulesTools.getDeclaringModule(method));
        if (bodyNode != null) {
            IMemento[] iMementoArray = bodyNode.getChildren("div");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if (method.getName().equals(node.getString("data-method")) && "command".equals(node.getString("class"))) {
                    Map<String, String> examples;
                    String returnValueDescription;
                    StringBuffer helpContent = new StringBuffer();
                    HTMLPrinter.addSmallHeader((StringBuffer)helpContent, (String)ModuleHelp.getImageAndLabel(ModuleHelp.getImageLocation("icons/eobj16/function.png"), ModuleHelp.createSynopsis(method)));
                    helpContent.append("<br />");
                    IMemento[] iMementoArray2 = node.getChildren();
                    int n3 = iMementoArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMemento contentNode = iMementoArray2[n4];
                        if ("description".equals(contentNode.getString("class"))) {
                            helpContent.append("<p>");
                            helpContent.append(ModuleHelp.getNodeContent(contentNode));
                            helpContent.append("</p>");
                        }
                        ++n4;
                    }
                    if (method.getParameters().length > 0) {
                        Map<String, String> parameterDescription = ModuleHelp.extractDescriptions(node, "parameters", "data-parameter");
                        helpContent.append("<dl>");
                        if (method.getParameters().length > 0) {
                            void var9_12;
                            helpContent.append("<dt>Parameters:</dt>");
                            Parameter[] parameterArray = method.getParameters();
                            int n5 = parameterArray.length;
                            boolean bl = false;
                            while (var9_12 < n5) {
                                Parameter parameter = parameterArray[var9_12];
                                helpContent.append("<dd>");
                                helpContent.append("<b>");
                                if (parameter.isAnnotationPresent(ScriptParameter.class)) {
                                    helpContent.append("<i>");
                                }
                                helpContent.append(parameter.getName());
                                if (parameter.isAnnotationPresent(ScriptParameter.class)) {
                                    helpContent.append("</i>");
                                }
                                helpContent.append("</b> ");
                                if (parameterDescription.containsKey(parameter.getName())) {
                                    helpContent.append(parameterDescription.get(parameter.getName()));
                                }
                                helpContent.append("</dd>");
                                ++var9_12;
                            }
                            helpContent.append("</dl>");
                        }
                    }
                    if ((returnValueDescription = ModuleHelp.extractReturnValueDescription(node)) != null) {
                        helpContent.append("<dl>");
                        helpContent.append("<dt>Returns:</dt>");
                        helpContent.append("<dd>");
                        helpContent.append(returnValueDescription);
                        helpContent.append("</dd>");
                        helpContent.append("</dl>");
                    }
                    if (method.getExceptionTypes().length > 0) {
                        Map<String, String> exceptionDescription = ModuleHelp.extractDescriptions(node, "exceptions", "data-exception");
                        helpContent.append("<dl>");
                        helpContent.append("<dt>Throws:</dt>");
                        Class<?>[] classArray = method.getExceptionTypes();
                        int n5 = classArray.length;
                        int n7 = 0;
                        while (n7 < n5) {
                            Class<?> clazz = classArray[n7];
                            helpContent.append("<dd>");
                            helpContent.append("<b>").append(ModuleHelp.createLink("some location", clazz.getSimpleName())).append("</b>");
                            if (exceptionDescription.containsKey(clazz.getSimpleName())) {
                                helpContent.append(" - ").append(exceptionDescription.get(clazz.getSimpleName()));
                            } else if (exceptionDescription.containsKey(clazz.getName())) {
                                helpContent.append(" - ").append(exceptionDescription.get(clazz.getName()));
                            }
                            helpContent.append("</dd>");
                            ++n7;
                        }
                        helpContent.append("</dl>");
                    }
                    if (!(examples = ModuleHelp.extractExamples(node)).isEmpty()) {
                        helpContent.append("<dl>");
                        helpContent.append("<dt>Examples:</dt>");
                        for (Map.Entry entry : examples.entrySet()) {
                            helpContent.append("<dd><div class=\"code\">");
                            helpContent.append((String)entry.getKey());
                            helpContent.append("</div><div class=\"description\">");
                            helpContent.append((String)entry.getValue());
                            helpContent.append("</div></dd>");
                        }
                        helpContent.append("</dl>");
                    }
                    return helpContent.toString();
                }
                ++n2;
            }
        }
        return null;
    }

    private static String extractReturnValueDescription(IMemento methodNode) {
        IMemento[] iMementoArray = methodNode.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("return".equals(node.getString("class"))) {
                return ModuleHelp.getNodeContent(node);
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, String> extractDescriptions(IMemento methodNode, String type, String keyAttribute) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        IMemento[] iMementoArray = methodNode.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if (type.equals(node.getString("class"))) {
                ArrayList<IMemento> candidates = new ArrayList<IMemento>();
                candidates.addAll(Arrays.asList(node.getChildren()));
                int argumentCounter = 0;
                while (!candidates.isEmpty()) {
                    IMemento candidate = (IMemento)candidates.remove(0);
                    if ("description".equals(candidate.getString("class"))) {
                        String parameterName = candidate.getString(keyAttribute);
                        parameters.put(parameterName, ModuleHelp.getNodeContent(candidate));
                        parameters.put("arg" + argumentCounter, ModuleHelp.getNodeContent(candidate));
                        ++argumentCounter;
                        continue;
                    }
                    candidates.addAll(0, Arrays.asList(candidate.getChildren()));
                }
            }
            ++n2;
        }
        return parameters;
    }

    private static Map<String, String> extractExamples(IMemento methodNode) {
        HashMap<String, String> examples = new HashMap<String, String>();
        IMemento[] iMementoArray = methodNode.getChildren();
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento node = iMementoArray[n2];
            if ("examples".equals(node.getString("class"))) {
                String key = null;
                IMemento[] iMementoArray2 = node.getChildren();
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento child = iMementoArray2[n4];
                    if (key == null) {
                        key = ModuleHelp.getNodeContent(child);
                    } else {
                        examples.put(key, ModuleHelp.getNodeContent(child));
                        key = null;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return examples;
    }

    public static String getNodeContent(IMemento node) {
        String candidate = node.toString();
        int startPos = candidate.indexOf("<" + node.getType());
        if (startPos != -1) {
            startPos = candidate.indexOf(62, startPos);
        }
        int endPos = candidate.lastIndexOf("<");
        if (startPos != -1 && endPos != -1 && startPos < endPos) {
            return candidate.substring(startPos + 1, endPos);
        }
        return node.getTextData() != null ? node.getTextData() : "";
    }

    private static String createSynopsis(Method method) {
        StringBuilder builder = new StringBuilder();
        Class<?> returnType = method.getReturnType();
        if (Void.TYPE.equals(returnType)) {
            builder.append("void");
        } else {
            builder.append(ModuleHelp.createLink("some location", returnType.getSimpleName()));
        }
        builder.append(' ');
        builder.append(method.getName());
        builder.append('(');
        Parameter[] parameterArray = method.getParameters();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            if (parameter.isAnnotationPresent(ScriptParameter.class)) {
                builder.append('[');
            }
            builder.append(ModuleHelp.createLink("some location", parameter.getType().getSimpleName()));
            builder.append(' ');
            builder.append(parameter.getName());
            if (parameter.isAnnotationPresent(ScriptParameter.class)) {
                builder.append(']');
            }
            builder.append(", ");
            ++n2;
        }
        if (method.getParameterCount() > 0) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append(')');
        return builder.toString();
    }

    public static String getConstantHelpTip(Field field) {
        IMemento bodyNode = ModuleHelp.getHelpContent(ModulesTools.getDeclaringModule(field));
        if (bodyNode != null) {
            IMemento[] iMementoArray = bodyNode.getChildren("table");
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento node = iMementoArray[n2];
                if ("constants".equals(node.getString("class"))) {
                    ArrayList<IMemento> candidates = new ArrayList<IMemento>();
                    candidates.addAll(Arrays.asList(node.getChildren()));
                    while (!candidates.isEmpty()) {
                        IMemento candidate = (IMemento)candidates.remove(0);
                        if (field.getName().equals(candidate.getString("data-field"))) {
                            StringBuffer helpContent = new StringBuffer();
                            HTMLPrinter.addSmallHeader((StringBuffer)helpContent, (String)ModuleHelp.getImageAndLabel(ModuleHelp.getImageLocation("icons/eobj16/field.png"), field.getName()));
                            helpContent.append("<br />");
                            helpContent.append(ModuleHelp.getNodeContent(candidate));
                            return helpContent.toString();
                        }
                        candidates.addAll(Arrays.asList(candidate.getChildren()));
                    }
                    break;
                }
                ++n2;
            }
        }
        return null;
    }
}

