/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.uibuilder;

import java.util.ArrayList;
import org.eclipse.ease.modules.platform.uibuilder.IPlaceHolder;
import org.eclipse.ease.modules.platform.uibuilder.IRenderer;
import org.eclipse.ease.modules.platform.uibuilder.LabelPlaceHolder;
import org.eclipse.ease.modules.platform.uibuilder.ViewModel;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CompositeRenderer
implements IRenderer,
PaintListener {
    private final Composite fParent;
    private ViewModel fViewModel;
    private boolean fShowGrid = false;

    public CompositeRenderer(Composite parent) {
        this.fParent = parent;
    }

    @Override
    public void setViewModel(ViewModel viewModel) {
        this.fViewModel = viewModel;
    }

    @Override
    public IPlaceHolder createPlaceHolder(Point position) {
        LabelPlaceHolder placeHolder = new LabelPlaceHolder(this.fParent, position.y, position.x);
        placeHolder.setVisible(this.fShowGrid);
        return placeHolder;
    }

    public Composite getParent() {
        return this.fParent;
    }

    private GridLayout getLayout() {
        return (GridLayout)this.getParent().getLayout();
    }

    public void update() {
        Control predecessor = null;
        for (Object element : this.fViewModel.getElements()) {
            if (!(element instanceof Control)) continue;
            ((Control)element).moveBelow(predecessor);
            predecessor = (Control)element;
        }
        this.getLayout().numColumns = this.fViewModel.getColumnCount();
        this.getParent().layout(true);
    }

    public void setShowGrid(boolean showGrid) {
        this.fShowGrid = showGrid;
        if (showGrid) {
            this.getParent().addPaintListener((PaintListener)this);
        } else {
            this.getParent().removePaintListener((PaintListener)this);
        }
        for (Object element : this.fViewModel.getElements()) {
            if (!(element instanceof LabelPlaceHolder)) continue;
            ((LabelPlaceHolder)element).setVisible(showGrid);
        }
    }

    public void paintControl(PaintEvent e) {
        e.gc.setForeground(Display.getCurrent().getSystemColor(3));
        ArrayList<Rectangle> columns = new ArrayList<Rectangle>();
        while (columns.size() < this.fViewModel.getColumnCount()) {
            columns.add(new Rectangle(0, 0, 0, 0));
        }
        ArrayList<Rectangle> rows = new ArrayList<Rectangle>();
        while (rows.size() < this.fViewModel.getRowCount()) {
            rows.add(new Rectangle(0, 0, 0, 0));
        }
        for (Object element : this.fViewModel.getElements()) {
            if (!(element instanceof Control)) continue;
            Rectangle bounds = ((Control)element).getBounds();
            Point columnRowLocation = this.fViewModel.indexToPoint(this.fViewModel.getElements().indexOf(element));
            Rectangle column = (Rectangle)columns.get(columnRowLocation.x - 1);
            Rectangle row = (Rectangle)rows.get(columnRowLocation.y - 1);
            if (((GridData)((Control)element).getLayoutData()).horizontalSpan == 1) {
                this.merge(bounds, column);
            }
            if (((GridData)((Control)element).getLayoutData()).verticalSpan != 1) continue;
            this.merge(bounds, row);
        }
        Rectangle firstRow = (Rectangle)rows.get(0);
        Rectangle lastRow = (Rectangle)rows.get(rows.size() - 1);
        for (Rectangle rectangle : columns) {
            rectangle.y = firstRow.y;
            rectangle.height = lastRow.y + lastRow.height - firstRow.y;
            e.gc.drawRectangle(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
        }
        Rectangle firstColumn = (Rectangle)columns.get(0);
        Rectangle lastColumn = (Rectangle)columns.get(columns.size() - 1);
        for (Rectangle rectangle : rows) {
            rectangle.x = firstColumn.x;
            rectangle.width = lastColumn.x + lastColumn.width - firstColumn.x;
            e.gc.drawRectangle(rectangle.x - 3, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
        }
    }

    private void merge(Rectangle source, Rectangle target) {
        if (target.x == 0) {
            target.x = source.x;
        }
        if (target.y == 0) {
            target.y = source.y;
        }
        if (target.width == 0) {
            target.width = source.width;
        }
        if (target.height == 0) {
            target.height = source.height;
        }
        target.add(source);
    }
}

