/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.module;

import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.appserv.connectors.internal.api.ConnectorsClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.deploy.shared.AbstractArchiveHandler;
import com.sun.enterprise.security.perms.PermsArchiveDelegate;
import com.sun.enterprise.security.perms.SMGlobalPolicyUtil;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.loader.util.ASClassLoaderUtil;
import org.jvnet.hk2.annotations.Service;

@Service(name="rar")
public class RarHandler
extends AbstractArchiveHandler {
    @Inject
    private ConnectorsClassLoaderUtil loader;
    @Inject
    @Named(value="rar")
    private ArchiveDetector detector;
    private Logger _logger = LogDomains.getLogger(RarHandler.class, (String)"javax.enterprise.resource.resourceadapter");

    public String getArchiveType() {
        return "rar";
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return this.detector.handles(archive);
    }

    public ClassLoader getClassLoader(ClassLoader parent, DeploymentContext context) {
        try {
            ConnectorClassFinder carCL;
            String moduleDir = context.getSource().getURI().getPath();
            String moduleName = context.getSource().getName();
            List appLibs = null;
            try {
                appLibs = context.getAppLibs();
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "installed libraries (--applibs and EXTENSTION_LIST) for rar [ " + moduleName + " ] :  " + appLibs);
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            if (this.isEmbedded(context)) {
                String applicationName = ConnectorsUtil.getApplicationName((DeploymentContext)context);
                String embeddedRarName = ConnectorsUtil.getEmbeddedRarModuleName((String)applicationName, (String)moduleName);
                carCL = this.loader.createRARClassLoader(moduleDir, parent.getParent().getParent(), embeddedRarName, appLibs);
            } else {
                carCL = this.loader.createRARClassLoader(moduleDir, null, moduleName, appLibs);
            }
            try {
                DeploymentContext dc = context;
                ConnectorClassFinder cl = carCL;
                AccessController.doPrivileged(new PermsArchiveDelegate.SetPermissionsAction(SMGlobalPolicyUtil.CommponentType.rar, dc, (ClassLoader)cl));
            }
            catch (PrivilegedActionException e) {
                throw new SecurityException(e.getException());
            }
            return carCL;
        }
        catch (ConnectorRuntimeException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isEmbedded(DeploymentContext context) {
        ReadableArchive archive = context.getSource();
        return archive != null && archive.getParentArchive() != null;
    }

    public List<URI> getClassPathURIs(ReadableArchive archive) {
        List uris = super.getClassPathURIs(archive);
        try {
            File archiveFile = new File(archive.getURI());
            if (archiveFile.exists() && archiveFile.isDirectory()) {
                uris.addAll(ASClassLoaderUtil.getLibDirectoryJarURIs((File)archiveFile));
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, e.getMessage(), e);
        }
        return uris;
    }
}

