/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Level;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

public abstract class AbstractStaxProvider<T>
extends BaseProvider<T> {
    private static final XMLOutputFactory XML_FACTORY = XMLOutputFactory.newInstance();
    private static final MappedNamespaceConvention JSON_CONVENTION = new MappedNamespaceConvention();
    private static final MediaType ANY_XML_MEDIATYPE = new MediaType("*", "xml");

    public AbstractStaxProvider(Class desiredType, MediaType ... mediaType) {
        super(desiredType, mediaType);
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type, Type genericType) {
        return this.desiredType.isAssignableFrom(type);
    }

    protected static XMLStreamWriter getXmlWriter(OutputStream os, boolean indent) throws XMLStreamException {
        XMLStreamWriter wr = XML_FACTORY.createXMLStreamWriter(os, "UTF-8");
        if (indent) {
            wr = new IndentingXMLStreamWriter(wr);
        }
        return wr;
    }

    protected static XMLStreamWriter getJsonWriter(OutputStream os, boolean indent) throws UnsupportedEncodingException {
        return new MappedXMLStreamWriter(JSON_CONVENTION, (Writer)new OutputStreamWriter(os, "UTF-8"));
    }

    protected PrePostFixedWriter getWriter(MediaType mediaType, OutputStream os, boolean indent) throws IOException {
        if (mediaType != null && "xml".equals(mediaType.getSubtype())) {
            try {
                return new PrePostFixedWriter(AbstractStaxProvider.getXmlWriter(os, indent));
            }
            catch (XMLStreamException ex) {
                throw new IOException(ex);
            }
        }
        String callBackJSONP = this.getCallBackJSONP();
        if (callBackJSONP != null) {
            return new PrePostFixedWriter(AbstractStaxProvider.getJsonWriter(os, indent), callBackJSONP + "(", ")");
        }
        return new PrePostFixedWriter(AbstractStaxProvider.getJsonWriter(os, indent));
    }

    protected abstract void writeContentToStream(T var1, XMLStreamWriter var2) throws XMLStreamException;

    @Override
    public String getContent(T proxy) {
        throw new UnsupportedOperationException("Provides only streaming implementation");
    }

    @Override
    public void writeTo(T proxy, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            PrePostFixedWriter writer = this.getWriter(mediaType, entityStream, super.getFormattingIndentLevel() > -1);
            if (writer.getPrefix() != null) {
                entityStream.write(writer.getPrefix().getBytes("UTF-8"));
            }
            this.writeContentToStream(proxy, writer.getWriter());
            if (writer.getPostfix() != null) {
                entityStream.write(writer.getPostfix().getBytes("UTF-8"));
            }
        }
        catch (XMLStreamException uee) {
            RestLogging.restLogger.log(Level.SEVERE, "NCLS-REST-00007", uee);
            throw new WebApplicationException((Throwable)uee, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected class PrePostFixedWriter {
        private String prefix;
        private String postfix;
        private XMLStreamWriter writer;

        public PrePostFixedWriter(XMLStreamWriter writer, String prefix, String postfix) {
            this.prefix = prefix;
            this.postfix = postfix;
            this.writer = writer;
        }

        public PrePostFixedWriter(XMLStreamWriter writer) {
            this(writer, null, null);
        }

        public String getPostfix() {
            return this.postfix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public XMLStreamWriter getWriter() {
            return this.writer;
        }
    }
}

