/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.cdi;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.mvc.Controller;
import jakarta.mvc.RedirectScoped;
import jakarta.mvc.event.MvcEvent;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.MvcContextImpl;
import org.eclipse.krazo.binding.BeanValidationProducer;
import org.eclipse.krazo.binding.BindingResultManager;
import org.eclipse.krazo.binding.ConstraintViolationTranslator;
import org.eclipse.krazo.binding.convert.ConverterRegistry;
import org.eclipse.krazo.binding.convert.MvcConverterProvider;
import org.eclipse.krazo.binding.validate.ValidationInterceptor;
import org.eclipse.krazo.cdi.AroundControllerInterceptor;
import org.eclipse.krazo.cdi.RedirectScopeContext;
import org.eclipse.krazo.cdi.RedirectScopeManager;
import org.eclipse.krazo.cdi.types.AnnotatedTypeProcessor;
import org.eclipse.krazo.core.Messages;
import org.eclipse.krazo.core.ModelsImpl;
import org.eclipse.krazo.core.ViewResponseFilter;
import org.eclipse.krazo.core.ViewableWriter;
import org.eclipse.krazo.engine.FaceletsViewEngine;
import org.eclipse.krazo.engine.JspViewEngine;
import org.eclipse.krazo.engine.ViewEngineFinder;
import org.eclipse.krazo.event.AfterControllerEventImpl;
import org.eclipse.krazo.event.AfterProcessViewEventImpl;
import org.eclipse.krazo.event.BeforeControllerEventImpl;
import org.eclipse.krazo.event.BeforeProcessViewEventImpl;
import org.eclipse.krazo.event.ControllerRedirectEventImpl;
import org.eclipse.krazo.forms.HiddenMethodFilter;
import org.eclipse.krazo.jaxrs.JaxRsContextProducer;
import org.eclipse.krazo.lifecycle.EventDispatcher;
import org.eclipse.krazo.lifecycle.RequestLifecycle;
import org.eclipse.krazo.locale.DefaultLocaleResolver;
import org.eclipse.krazo.locale.LocaleResolverChain;
import org.eclipse.krazo.security.CsrfImpl;
import org.eclipse.krazo.security.CsrfProtectFilter;
import org.eclipse.krazo.security.CsrfTokenManager;
import org.eclipse.krazo.security.CsrfValidateFilter;
import org.eclipse.krazo.security.EncodersImpl;
import org.eclipse.krazo.uri.ApplicationUris;
import org.eclipse.krazo.uri.UriTemplateParser;
import org.eclipse.krazo.util.CdiUtils;

public class KrazoCdiExtension
implements Extension {
    private static final Logger log = Logger.getLogger(KrazoCdiExtension.class.getName());
    private static Set<Class<? extends MvcEvent>> observedEvents;
    private final AnnotatedTypeProcessor annotatedTypeProcessor = new AnnotatedTypeProcessor();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        log.fine("Observed BeforeBeanDiscovery event, registering scopes and beans...");
        event.addScope(RedirectScoped.class, true, true);
        CdiUtils.addAnnotatedTypes(event, beanManager, MvcContextImpl.class, KrazoConfig.class, BeanValidationProducer.class, BindingResultManager.class, ConstraintViolationTranslator.class, ConverterRegistry.class, MvcConverterProvider.class, Messages.class, ModelsImpl.class, ViewableWriter.class, ViewResponseFilter.class, EventDispatcher.class, RequestLifecycle.class, FaceletsViewEngine.class, JspViewEngine.class, ViewEngineFinder.class, CsrfImpl.class, CsrfProtectFilter.class, CsrfValidateFilter.class, CsrfTokenManager.class, EncodersImpl.class, CdiUtils.class, RedirectScopeManager.class, ValidationInterceptor.class, AroundControllerInterceptor.class, AfterControllerEventImpl.class, AfterProcessViewEventImpl.class, BeforeControllerEventImpl.class, BeforeProcessViewEventImpl.class, ControllerRedirectEventImpl.class, LocaleResolverChain.class, DefaultLocaleResolver.class, JaxRsContextProducer.class, ApplicationUris.class, UriTemplateParser.class, HiddenMethodFilter.class);
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        event.addContext((Context)new RedirectScopeContext());
    }

    public <T> void processAnnotatedType(@Observes @Priority(value=4000) @WithAnnotations(value={Controller.class}) ProcessAnnotatedType<T> pat) {
        AnnotatedType replacement = this.annotatedTypeProcessor.getReplacement(pat.getAnnotatedType());
        if (replacement != null) {
            log.log(Level.FINE, "Replacing AnnotatedType of class: {0}", replacement.getJavaClass().getName());
            pat.setAnnotatedType(replacement);
        }
    }

    public <T, X> void processObserverMethod(@Observes ProcessObserverMethod<T, X> pom, BeanManager beanManager) {
        Class clazz;
        Type type = pom.getObserverMethod().getObservedType();
        if (type instanceof Class && MvcEvent.class.isAssignableFrom(clazz = (Class)type)) {
            KrazoCdiExtension.addObservedEvent((Class)type);
        }
    }

    public static synchronized void addObservedEvent(Class<? extends MvcEvent> eventType) {
        if (observedEvents == null) {
            observedEvents = new HashSet<Class<? extends MvcEvent>>();
        }
        observedEvents.add(eventType);
    }

    public static synchronized boolean isEventObserved(Class<? extends MvcEvent> eventType) {
        return observedEvents != null && observedEvents.contains(eventType);
    }
}

