/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.Nonbinding;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.logging.ResolutionLogger;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.security.SetAccessibleAction;
import org.jboss.weld.util.collections.ImmutableMap;
import org.jboss.weld.util.collections.ImmutableSet;
import org.jboss.weld.util.reflection.Formats;

public class QualifierInstance {
    public static final QualifierInstance ANY = new QualifierInstance(Any.class);
    public static final QualifierInstance DEFAULT = new QualifierInstance(Default.class);
    private final Class<? extends Annotation> annotationClass;
    private final Map<String, Object> values;
    private final int hashCode;

    public static Set<QualifierInstance> of(Set<Annotation> qualifiers, MetaAnnotationStore store) {
        if (qualifiers.isEmpty()) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder<QualifierInstance> ret = ImmutableSet.builder();
        for (Annotation a : qualifiers) {
            ret.add(QualifierInstance.of(a, store));
        }
        return ret.build();
    }

    public static Set<QualifierInstance> of(Bean<?> bean, MetaAnnotationStore store) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.of(bean.getQualifiers(), store);
    }

    public static QualifierInstance of(Annotation annotation, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        if (Any.class == annotationType) {
            return ANY;
        }
        if (Default.class == annotationType) {
            return DEFAULT;
        }
        if (Named.class == annotationType) {
            Named named = (Named)annotation;
            return new QualifierInstance(annotationType, ImmutableMap.of("value", named.value()));
        }
        return new QualifierInstance(annotationType, QualifierInstance.createValues(annotation, store));
    }

    private QualifierInstance(Class<? extends Annotation> annotationClass) {
        this(annotationClass, Collections.emptyMap());
    }

    public QualifierInstance(Class<? extends Annotation> annotationClass, Map<String, Object> values) {
        this.annotationClass = annotationClass;
        this.values = values;
        this.hashCode = Objects.hash(annotationClass, values);
    }

    private static Map<String, Object> createValues(Annotation instance, MetaAnnotationStore store) {
        Class<? extends Annotation> annotationClass = instance.annotationType();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(annotationClass);
        if (model.getAnnotatedAnnotation().getMethods().size() == 0) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder<String, Object> builder = ImmutableMap.builder();
        for (AnnotatedMethod method : model.getAnnotatedAnnotation().getMethods()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(SetAccessibleAction.of(method.getJavaMember()));
                } else {
                    method.getJavaMember().setAccessible(true);
                }
                builder.put(method.getJavaMember().getName(), method.getJavaMember().invoke((Object)instance, new Object[0]));
            }
            catch (IllegalArgumentException e) {
                builder = ImmutableMap.builder();
                Method[] methods = System.getSecurityManager() != null ? AccessController.doPrivileged(new GetDeclaredMethodsAction(annotationClass)) : annotationClass.getDeclaredMethods();
                for (Method m : methods) {
                    if (m.getAnnotation(Nonbinding.class) != null) continue;
                    try {
                        builder.put(m.getName(), m.invoke((Object)instance, new Object[0]));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw ResolutionLogger.LOG.cannotCreateQualifierInstanceValues(instance, Formats.formatAsStackTraceElement(method.getJavaMember()), ex);
                    }
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw ResolutionLogger.LOG.cannotCreateQualifierInstanceValues(instance, Formats.formatAsStackTraceElement(method.getJavaMember()), e);
            }
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return this.values.equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public Object getValue(String name) {
        return this.values.get(name);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance {annotationClass=" + this.annotationClass + ", values=" + this.values + '}';
    }
}

