/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.RelativePathResolver;

public class ConnectorConfigProperty
extends EnvironmentProperty {
    private boolean ignore = false;
    private boolean supportsDynamicUpdates = false;
    private boolean confidential = false;
    private boolean setIgnoreCalled = false;
    private boolean setConfidentialCalled = false;
    private boolean setSupportsDynamicUpdatesCalled = false;
    private static final Logger _logger = DOLUtils.getDefaultLogger();

    public ConnectorConfigProperty() {
    }

    public ConnectorConfigProperty(String name, String value, String description) {
        this(name, value, description, null);
    }

    public ConnectorConfigProperty(String name, String value, String description, String type) {
        super(name, value, description, type);
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
        this.setSetIgnoreCalled(true);
    }

    @Override
    public String getValue() {
        String value = super.getValue();
        if (this.confidential) {
            try {
                return RelativePathResolver.getRealPasswordFromAlias((String)value);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "Unable to resolve alias value [ " + value + " ] for connector config-property [ " + this.getName() + " ]", e);
            }
        }
        return value;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    public boolean isSupportsDynamicUpdates() {
        return this.supportsDynamicUpdates;
    }

    public void setSupportsDynamicUpdates(boolean supportsDynamicUpdates) {
        this.supportsDynamicUpdates = supportsDynamicUpdates;
        this.setSetSupportsDynamicUpdatesCalled(true);
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
        this.setSetConfidentialCalled(true);
    }

    public boolean isSetIgnoreCalled() {
        return this.setIgnoreCalled;
    }

    public void setSetIgnoreCalled(boolean setIgnoreCalled) {
        this.setIgnoreCalled = setIgnoreCalled;
    }

    public boolean isSetConfidentialCalled() {
        return this.setConfidentialCalled;
    }

    public void setSetConfidentialCalled(boolean setConfidentialCalled) {
        this.setConfidentialCalled = setConfidentialCalled;
    }

    public boolean isSetSupportsDynamicUpdatesCalled() {
        return this.setSupportsDynamicUpdatesCalled;
    }

    public void setSetSupportsDynamicUpdatesCalled(boolean setSupportsDynamicUpdatesCalled) {
        this.setSupportsDynamicUpdatesCalled = setSupportsDynamicUpdatesCalled;
    }
}

