/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;

public class LogFilter
extends BaseFilter {
    private final Logger logger;
    private final Level level;

    public LogFilter() {
        this(null, null);
    }

    public LogFilter(Logger logger) {
        this(logger, null);
    }

    public LogFilter(Logger logger, Level level) {
        this.logger = logger != null ? logger : Grizzly.logger(LogFilter.class);
        this.level = level != null ? level : Level.INFO;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public void onAdded(FilterChain filterChain) {
        this.logger.log(this.level, "LogFilter onAdded");
    }

    @Override
    public void onRemoved(FilterChain filterChain) {
        this.logger.log(this.level, "LogFilter onRemoved");
    }

    @Override
    public void onFilterChainChanged(FilterChain filterChain) {
        this.logger.log(this.level, "LogFilter onFilterChainChanged");
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        this.logger.log(this.level, "LogFilter handleRead. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx) throws IOException {
        this.logger.log(this.level, "LogFilter handleWrite. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx) throws IOException {
        this.logger.log(this.level, "LogFilter handleConnect. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        this.logger.log(this.level, "LogFilter handleAccept. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        return ctx.getInvokeAction();
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        this.logger.log(this.level, "LogFilter handleClose. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
        return ctx.getInvokeAction();
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        this.logger.log(this.level, "LogFilter exceptionOccured. Connection={0} message={1}", new Object[]{ctx.getConnection(), ctx.getMessage()});
    }
}

