/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.NodeInfo;

public class ClassDependencyBuilder {
    private Map<String, NodeInfo> mappings = new HashMap<String, NodeInfo>();

    public Set<String> computeResult(String name) {
        NodeInfo ni = this.mappings.get(name = name.replace('.', '/'));
        if (ni != null) {
            if (ni.isAnnotation()) {
                return this.getAnnotatedClasses(ni);
            }
            if (ni.isClass() || ni.isInterface()) {
                return this.getSubClasses(ni, ni.isInterface());
            }
        }
        return new HashSet<String>();
    }

    private Set<String> getAnnotatedClasses(NodeInfo ni) {
        Set<NodeInfo> nInfos;
        HashSet<String> annotatedClasses = new HashSet<String>();
        if (ni != null && (nInfos = ni.getDirectImplementors()) != null && nInfos.size() > 0) {
            for (NodeInfo n : nInfos) {
                annotatedClasses.add(n.getClassName());
            }
        }
        return annotatedClasses;
    }

    private Set<String> getSubClasses(NodeInfo node, boolean addImplementors) {
        HashSet<String> assignables = new HashSet<String>();
        if (node != null) {
            LinkedList<NodeInfo> list = new LinkedList<NodeInfo>();
            while (true) {
                Set<NodeInfo> intfs;
                Set<NodeInfo> set;
                if ((set = node.getDirectSubClass()) != null && set.size() > 0) {
                    for (NodeInfo n : set) {
                        list.add(n);
                    }
                }
                if (addImplementors && (intfs = node.getDirectImplementors()) != null && intfs.size() > 0) {
                    for (NodeInfo n : intfs) {
                        list.add(n);
                    }
                }
                if (list.size() <= 0) break;
                node = (NodeInfo)((Object)list.remove(0));
                String name = node.getClassName();
                if (assignables.contains(name)) continue;
                assignables.add(name);
            }
        }
        return assignables;
    }

    public void loadClassData(byte[] classData) throws Exception {
        NodeInfo node = new NodeInfo(classData);
        String cname = node.getClassName();
        NodeInfo nodeInfo = this.mappings.get(cname);
        if (nodeInfo == null || !nodeInfo.isParsed()) {
            if (nodeInfo == null) {
                this.mappings.put(cname, node);
                nodeInfo = node;
            } else {
                nodeInfo.load(classData);
            }
            this.populateMapping(nodeInfo);
        }
    }

    public int size() {
        return this.mappings.size();
    }

    private void populateMapping(NodeInfo nodeInfo) {
        List<String> anns;
        String[] interfaces;
        String superName = nodeInfo.getSuperClassName();
        if (superName != null) {
            NodeInfo superNodeInfo = this.mappings.get(superName);
            if (superNodeInfo == null) {
                superNodeInfo = new NodeInfo(superName);
                if (nodeInfo.isClass()) {
                    superNodeInfo.markAsClassType();
                } else {
                    superNodeInfo.markAsInterfaceType();
                }
                this.mappings.put(superName, superNodeInfo);
            }
            superNodeInfo.addDirectSubClass(nodeInfo);
        }
        if ((interfaces = nodeInfo.getInterfaces()) != null && interfaces.length > 0) {
            for (String interf : interfaces) {
                NodeInfo interfNodeInfo = this.mappings.get(interf);
                if (interfNodeInfo == null) {
                    interfNodeInfo = new NodeInfo(interf);
                    interfNodeInfo.markAsInterfaceType();
                    this.mappings.put(interf, interfNodeInfo);
                }
                interfNodeInfo.addDirectImplementor(nodeInfo);
            }
        }
        if ((anns = nodeInfo.getClassLevelAnnotations()) != null && anns.size() > 0) {
            for (String ann : anns) {
                NodeInfo annNode = this.mappings.get(ann);
                if (annNode == null) {
                    annNode = new NodeInfo(ann);
                    annNode.markAsAnnotaionType();
                    this.mappings.put(ann, annNode);
                }
                annNode.addDirectImplementor(nodeInfo);
            }
        }
    }

    void printInfo() {
        for (NodeInfo node : this.mappings.values()) {
            System.out.println(node.toString());
        }
    }
}

