/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.animation.pagetransition.animation;

import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.scene.Node;
import javafx.util.Duration;
import org.eclipse.fx.ui.animation.pagetransition.CenterSwitchAnimation;

public class ZoomSlideAnimation
extends CenterSwitchAnimation {
    @Override
    protected Animation createAndPrepareAnimation(Node curNode, Node newNode) {
        double deltaX = -curNode.getBoundsInLocal().getWidth();
        newNode.setTranslateX(-deltaX);
        return new SequentialTransition(new Animation[]{new ParallelTransition(new Animation[]{ZoomSlideAnimation.zoomOut(curNode), ZoomSlideAnimation.zoomOut(newNode)}), new ParallelTransition(new Animation[]{ZoomSlideAnimation.slide(curNode, deltaX), ZoomSlideAnimation.slide(newNode, deltaX)}), new ParallelTransition(new Animation[]{ZoomSlideAnimation.zoomIn(curNode), ZoomSlideAnimation.zoomIn(newNode)})});
    }

    private static TranslateTransition slide(Node n, double deltaX) {
        TranslateTransition t = new TranslateTransition(Duration.millis((double)300.0), n);
        t.setInterpolator(Interpolator.EASE_BOTH);
        t.setByX(deltaX);
        return t;
    }

    private static ScaleTransition zoomIn(Node n) {
        ScaleTransition zoomIn = new ScaleTransition(Duration.millis((double)300.0), n);
        zoomIn.setToX(1.0);
        zoomIn.setToY(1.0);
        zoomIn.setInterpolator(Interpolator.EASE_BOTH);
        return zoomIn;
    }

    private static ScaleTransition zoomOut(Node n) {
        ScaleTransition zoomIn = new ScaleTransition(Duration.millis((double)300.0), n);
        zoomIn.setToX(0.7);
        zoomIn.setToY(0.7);
        zoomIn.setInterpolator(Interpolator.EASE_BOTH);
        return zoomIn;
    }

    @Override
    protected void resetProperties(Node curNode, Node newNode) {
        newNode.setTranslateX(0.0);
        newNode.setScaleX(1.0);
        newNode.setScaleY(1.0);
        curNode.setTranslateX(0.0);
        curNode.setScaleX(1.0);
        curNode.setScaleY(1.0);
        curNode.setEffect(null);
        newNode.setEffect(null);
    }
}

