/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.rules;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.fx.text.rules.CheckPointScanner;
import org.eclipse.fx.text.rules.ExtendedPatternRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;

public class DynamicEndRule
extends ExtendedPatternRule {
    private final char[] beginSuffix;
    private final Pattern beginPattern;
    private final String endTemplate;

    public DynamicEndRule(IToken token, String beginPrefix, Pattern beginPattern, String beginSuffix, String endTemplate) {
        super(beginPrefix, "", token, '\\', false, false);
        this.beginPattern = beginPattern;
        this.beginSuffix = beginSuffix == null ? new char[]{} : beginSuffix.toCharArray();
        this.endTemplate = endTemplate;
    }

    @Override
    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (!resume) {
            this.fEndSequence = new char[0];
        }
        return super.evaluate(scanner, resume);
    }

    @Override
    protected boolean sequenceStartDetected(ICharacterScanner scanner, char[] sequence, boolean eofAllowed) {
        CheckPointScanner cs = new CheckPointScanner(scanner);
        cs.setCheckpoint();
        boolean rv = super.sequenceStartDetected(cs, sequence, eofAllowed);
        if (rv) {
            if (this.beginSuffix.length > 0) {
                int c;
                rv = false;
                StringBuilder b = new StringBuilder();
                while ((c = cs.read()) != -1) {
                    if (c == 13 || c == 10) {
                        rv = false;
                        break;
                    }
                    if (c == this.beginSuffix[0]) {
                        Matcher matcher;
                        rv = super.sequenceDetected(cs, this.beginSuffix, false);
                        if (!rv || !(rv = (matcher = this.beginPattern.matcher(b)).matches())) continue;
                        Object[] g = new String[matcher.groupCount()];
                        int i = 0;
                        while (i < matcher.groupCount()) {
                            g[i] = matcher.group(i + 1);
                            ++i;
                        }
                        this.fEndSequence = MessageFormat.format(this.endTemplate, g).toCharArray();
                        break;
                    }
                    b.append((char)c);
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (!rv) {
            cs.rollbackToCheckPoint();
        }
        return rv;
    }
}

