/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import javax.annotation.PostConstruct;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPart;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolBar;

public abstract class BasePartRenderer<N, T, M>
extends BaseRenderer<MPart, WPart<N, T, M>> {
    public static final String VIEW_MENU_TAG = "ViewMenu";

    @PostConstruct
    void init(IEventBroker broker) {
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/iconURI/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/label/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/UILabel/tooltip/*");
        this.registerEventListener(broker, "org/eclipse/e4/ui/model/ui/Dirtyable/dirty/*");
    }

    @Override
    protected void initWidget(final MPart element, final WPart<N, T, M> widget) {
        super.initWidget(element, widget);
        widget.registerActivationCallback(new WCallback<Boolean, Void>(){

            @Override
            public Void call(Boolean param) {
                if (param.booleanValue()) {
                    boolean requiresFocus = BasePartRenderer.this.requiresFocus(widget);
                    if (requiresFocus) {
                        BasePartRenderer.this.activate(element, true);
                    } else {
                        BasePartRenderer.this.activate(element, false);
                    }
                }
                return null;
            }
        });
    }

    protected abstract boolean requiresFocus(WPart<N, T, M> var1);

    @Override
    public void doProcessContent(MPart element) {
        WPart widget = (WPart)this.getWidget((MUIElement)element);
        if (element.getToolbar() != null) {
            WToolBar toolbar = (WToolBar)this.engineCreateWidget(element.getToolbar());
            widget.setToolbar(toolbar);
        }
        for (MMenu m : element.getMenus()) {
            if (!m.getTags().contains(VIEW_MENU_TAG)) continue;
            WMenu menu = (WMenu)this.engineCreateWidget(m);
            widget.setMenu(menu);
            break;
        }
        Class<?> cl = widget.getWidget().getClass();
        do {
            element.getContext().set(cl.getName(), widget.getWidget());
        } while (!(cl = cl.getSuperclass()).getName().equals("java.lang.Object"));
        IContributionFactory contributionFactory = (IContributionFactory)element.getContext().get(IContributionFactory.class.getName());
        Object newPart = contributionFactory.create(element.getContributionURI(), element.getContext());
        element.setObject(newPart);
    }

    public void childRendered(MPart parentElement, MUIElement element) {
    }

    public void hideChild(MPart container, MUIElement changedObj) {
    }
}

