/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.osgi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.util.Builder;
import javafx.util.BuilderFactory;
import javafx.util.Callback;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OSGiFXMLLoader {
    public static <O> O load(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        ClassLoader loader = requester.getClassLoader();
        return OSGiFXMLLoader.load(loader, url, resourceBundle, builderFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        ClassLoader loader = requester.getClassLoader();
        return OSGiFXMLLoader.loadWithController(loader, url, resourceBundle, builderFactory);
    }

    public static <O> O load(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        return OSGiFXMLLoader.load(loader, url, resourceBundle, builderFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        return OSGiFXMLLoader.loadWithController(loader, url, resourceBundle, builderFactory);
    }

    public static <O> O load(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        return OSGiFXMLLoader.load(classloader, url, resourceBundle, builderFactory, null);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory) throws IOException {
        return OSGiFXMLLoader.loadWithController(classloader, url, resourceBundle, builderFactory, null);
    }

    public static <O> O load(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        ClassLoader loader = requester.getClassLoader();
        return OSGiFXMLLoader.load(loader, url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Class<?> requester, @NonNull String relativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = requester.getResource(relativeFxmlPath);
        ClassLoader loader = requester.getClassLoader();
        return OSGiFXMLLoader.loadWithController(loader, url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O> O load(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        return OSGiFXMLLoader.load(loader, url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull Bundle bundle, @NonNull String bundleRelativeFxmlPath, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        URL url = bundle.getResource(bundleRelativeFxmlPath);
        ClassLoader loader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
        return OSGiFXMLLoader.loadWithController(loader, url, resourceBundle, builderFactory, controllerFactory);
    }

    public static <O> O load(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        return (O)OSGiFXMLLoader.loadWithController((ClassLoader)classloader, (URL)url, (ResourceBundle)resourceBundle, (BuilderFactory)builderFactory, controllerFactory).node;
    }

    public static <O, C> FXMLData<O, C> loadWithController(@NonNull ClassLoader classloader, @NonNull URL url, @Nullable ResourceBundle resourceBundle, final @Nullable BuilderFactory builderFactory, @Nullable Callback<Class<?>, Object> controllerFactory) throws IOException {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(url);
        loader.setClassLoader(classloader);
        loader.setResources(resourceBundle);
        if (builderFactory == null) {
            loader.setBuilderFactory((BuilderFactory)new JavaFXBuilderFactory(classloader));
        } else {
            loader.setBuilderFactory(new BuilderFactory(classloader){
                private JavaFXBuilderFactory orgBuilder;
                {
                    this.orgBuilder = new JavaFXBuilderFactory(classLoader);
                }

                public Builder<?> getBuilder(Class<?> type) {
                    Builder b = builderFactory.getBuilder(type);
                    if (b == null) {
                        b = this.orgBuilder.getBuilder(type);
                    }
                    return b;
                }
            });
        }
        if (controllerFactory != null) {
            loader.setControllerFactory(controllerFactory);
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (InputStream in = url.openStream();){
            Object value = loader.load(in);
            in.close();
            return new FXMLData<Object, Object>(value, loader.getController());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class FXMLData<N, C> {
        @NonNull
        public final N node;
        @Nullable
        public final C controller;

        FXMLData(N node, C controller) {
            this.node = node;
            this.controller = controller;
        }
    }
}

