/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.common.helper.IDGeneratorHelper;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.common.ui.activator.AbstractUIActivator;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.data.FactoryComponentRegistry;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentDescriptor;
import org.eclipse.egf.model.internal.data.ModelElement;
import org.eclipse.egf.pde.internal.FactoryComponentGeneratorHelper;
import org.eclipse.egf.pde.internal.plugin.command.PluginChangesCommandRunner;
import org.eclipse.egf.pde.internal.plugin.extension.ContextExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.ContractElementRefExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.ContractExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.FactoryComponentExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.FactoryComponentInvocationExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.MappingExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.ProductionPlanExtensionFactory;
import org.eclipse.egf.pde.internal.plugin.extension.TaskFactoryExtensionFactory;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommandRunner;
import org.eclipse.egf.pde.plugin.extension.IContextExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IContractElementRefExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IContractExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IFactoryComponentExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IFactoryComponentInvocationExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IMappingExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.IProductionPlanExtensionFactory;
import org.eclipse.egf.pde.plugin.extension.ITaskFactoryExtensionFactory;
import org.eclipse.egf.pde.reader.PdeTargetPlatformReader;
import org.eclipse.egf.pde.reader.WorkspaceFactoryComponentReader;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertProjectToPluginOperation;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgfPdeActivator
extends AbstractUIActivator {
    private static final Logger __logger = Logger.getLogger((String)EgfPdeActivator.class.getPackage().getName());
    public static final String PLUGIN_FILE_NAME = "plugin.xml";
    public static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static EgfPdeActivator __plugin;
    private IPluginChangesCommandRunner _pluginChangesCommandRunner;

    public void start(BundleContext context_p) throws Exception {
        super.start(context_p);
        __plugin = this;
    }

    public void stop(BundleContext context_p) throws Exception {
        __plugin = null;
        super.stop(context_p);
    }

    public static EgfPdeActivator getDefault() {
        return __plugin;
    }

    public IFactoryComponentExtensionFactory getFactoryComponentExtensionHelper() {
        return FactoryComponentExtensionFactory.getInstance();
    }

    public IContractExtensionFactory getContractExtensionHelper() {
        return ContractExtensionFactory.getInstance();
    }

    public IContractElementRefExtensionFactory getContractElementRefExtensionHelper() {
        return ContractElementRefExtensionFactory.getInstance();
    }

    public IProductionPlanExtensionFactory getProductionPlanExtensionHelper() {
        return ProductionPlanExtensionFactory.getInstance();
    }

    public IFactoryComponentInvocationExtensionFactory getFactoryComponentInvocationExtensionHelper() {
        return FactoryComponentInvocationExtensionFactory.getInstance();
    }

    public ITaskFactoryExtensionFactory getTaskFactoryExtensionHelper() {
        return TaskFactoryExtensionFactory.getInstance();
    }

    public IContextExtensionFactory getContextExtensionHelper() {
        return ContextExtensionFactory.getInstance();
    }

    public IMappingExtensionFactory getMappingExtensionHelper() {
        return MappingExtensionFactory.getInstance();
    }

    protected IPluginModelBase getPluginModelForFactoryComponent(FactoryComponent factoryComponent_p) {
        if (factoryComponent_p == null) {
            return null;
        }
        return (IPluginModelBase)((ModelElement)factoryComponent_p).getAdapter(IPluginModelBase.class);
    }

    public IPluginModelBase getPluginModelBase(IProject project_p) {
        return PluginRegistry.findModel((IProject)project_p);
    }

    public IFile getFile(String factoryComponentId_p) {
        return this.getFile(EgfPdeActivator.getDefault().getPluginModelForFactoryComponent(factoryComponentId_p));
    }

    public IFile getFile(IPluginModelBase pluginModelBase_p) {
        return this.getFile(ProjectHelper.getProject((IPluginModelBase)pluginModelBase_p));
    }

    public IFile getFile(IProject project_p) {
        IFile result = null;
        if (project_p == null) {
            return result;
        }
        result = project_p.getFile(PLUGIN_FILE_NAME);
        result = result.exists() ? result : null;
        return result;
    }

    public boolean isPluginFile(IResource resource_p) {
        if (resource_p != null && resource_p instanceof IFile) {
            return ((IFile)resource_p).getName().equals(PLUGIN_FILE_NAME);
        }
        return false;
    }

    public String getFactoryComponentId(IProject project_p) {
        if (project_p == null) {
            return null;
        }
        IFactoryComponentDescriptor descriptor = WorkspaceFactoryComponentReader.getDefault().readFactoryComponent(project_p);
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    public String getPluginIdForFactoryComponent(String factoryComponentId_p) {
        if (factoryComponentId_p == null) {
            return null;
        }
        IPluginModelBase pluginModelBase = this.getPluginModelForFactoryComponent(factoryComponentId_p);
        if (pluginModelBase != null) {
            return pluginModelBase.getPluginBase().getId();
        }
        return null;
    }

    public IPluginModelBase getPluginModelForFactoryComponent(String factoryComponentId_p) {
        IPluginModelBase result = null;
        if (factoryComponentId_p == null) {
            return result;
        }
        FactoryComponentRegistry fcRegistry = CoreActivator.getDefault().getFactoryComponentRegistry();
        FactoryComponent retrievedFc = fcRegistry.getFactoryComponent(factoryComponentId_p);
        if (retrievedFc != null) {
            result = this.getPluginModelForFactoryComponent(retrievedFc);
            if (result == null) {
                IProject fcProject = ModelHelper.getProject((NamedModelElementWithId)retrievedFc);
                result = this.getPluginModelBase(fcProject);
                ((ModelElement)retrievedFc).setAdapter(IPluginModelBase.class, (Object)result);
            }
        } else {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IProject[] projects = workspaceRoot.getProjects();
            int i = 0;
            while (i < projects.length && result == null) {
                IProject project = projects[i];
                String projectFcId = this.getFactoryComponentId(project);
                if (factoryComponentId_p.equals(projectFcId)) {
                    result = this.getPluginModelBase(project);
                }
                ++i;
            }
        }
        return result;
    }

    public IProject getProjectForFactoryComponent(String factoryComponentId_p) {
        IProject result = null;
        if (factoryComponentId_p == null) {
            return result;
        }
        IPluginModelBase pluginModelBase = this.getPluginModelForFactoryComponent(factoryComponentId_p);
        if (pluginModelBase != null) {
            result = ProjectHelper.getProject((IPluginModelBase)pluginModelBase);
        }
        return result;
    }

    public Collection<FactoryComponent> getFactoryComponentsInWorkspace() {
        ArrayList<FactoryComponent> resultingFcList = new ArrayList<FactoryComponent>(0);
        for (IProject project : this.getPluginProjects()) {
            FactoryComponent fc = this.getFactoryComponent(project);
            if (fc == null) continue;
            resultingFcList.add(fc);
        }
        return resultingFcList;
    }

    public Collection<FactoryComponent> getFactoryComponentsInTargetPlatform() {
        ArrayList<FactoryComponent> result = new ArrayList<FactoryComponent>(0);
        IPluginModelBase[] targetPlatformModels = PluginRegistry.getExternalModels();
        PdeTargetPlatformReader reader = PdeTargetPlatformReader.getDefault();
        IPluginModelBase[] iPluginModelBaseArray = targetPlatformModels;
        int n = targetPlatformModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
            IFactoryComponentDescriptor descriptor = reader.readFactoryComponent(pluginModel);
            if (descriptor != null) {
                FactoryComponent fc = CoreActivator.getDefault().getFactoryComponent(descriptor);
                ModelElement modelElement = (ModelElement)fc;
                if (fc != null && modelElement.getAdapter(IPluginModelBase.class) == null) {
                    modelElement.setAdapter(IPluginModelBase.class, (Object)pluginModel);
                }
                result.add(fc);
            }
            ++n2;
        }
        return result;
    }

    public Collection<IProject> getPluginProjects() {
        IPluginModelBase[] workspaceModels;
        ArrayList<IProject> pluginProjects = new ArrayList<IProject>(0);
        IPluginModelBase[] iPluginModelBaseArray = workspaceModels = PluginRegistry.getWorkspaceModels();
        int n = workspaceModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
            IProject project = ProjectHelper.getProject((IPluginModelBase)pluginModel);
            if (project != null) {
                pluginProjects.add(project);
            }
            ++n2;
        }
        return pluginProjects;
    }

    public FactoryComponent getFactoryComponentForPluginId(String pluginId_p) {
        FactoryComponent result = null;
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        int i = 0;
        while (i < workspaceModels.length && result == null) {
            IPluginModelBase currentPlugin = workspaceModels[i];
            if (pluginId_p.equals(currentPlugin.getPluginBase().getId())) {
                IProject project = ProjectHelper.getProject((IPluginModelBase)currentPlugin);
                result = this.getFactoryComponent(project);
            }
            ++i;
        }
        return result;
    }

    public FactoryComponent getFactoryComponent(IProject project_p) {
        WorkspaceFactoryComponentReader reader;
        IFactoryComponentDescriptor descriptor;
        FactoryComponent fc = this.getFactoryComponentForProject(project_p);
        if (fc == null && (descriptor = (reader = WorkspaceFactoryComponentReader.getDefault()).readFactoryComponent(project_p)) != null && (fc = CoreActivator.getDefault().getFactoryComponent(descriptor)) != null) {
            IPluginModelBase pluginModelBase = this.getPluginModelBase(project_p);
            ModelElement modelElement = (ModelElement)fc;
            modelElement.setAdapter(IPluginModelBase.class, (Object)pluginModelBase);
            modelElement.setAdapter(IProject.class, (Object)project_p);
        }
        return fc;
    }

    protected FactoryComponent getFactoryComponentForProject(IProject project_p) {
        FactoryComponent result = null;
        if (project_p == null) {
            return result;
        }
        Iterator fcs = CoreActivator.getDefault().getFactoryComponentRegistry().getFactoryComponents().iterator();
        while (fcs.hasNext() && result == null) {
            FactoryComponent currentFc = (FactoryComponent)fcs.next();
            IPluginModelBase pluginModelBase = this.getPluginModelForFactoryComponent(currentFc);
            if (project_p != ProjectHelper.getProject((IPluginModelBase)pluginModelBase)) continue;
            result = currentFc;
        }
        return result;
    }

    public IPluginChangesCommandRunner getPluginChangesCommandRunner() {
        if (this._pluginChangesCommandRunner == null) {
            this._pluginChangesCommandRunner = new PluginChangesCommandRunner();
        }
        return this._pluginChangesCommandRunner;
    }

    public void addEntryInBinaryBuild(IProject project_p, String entryName_p) {
        if (project_p == null || entryName_p == null) {
            return;
        }
        WorkspaceBuildModel buildModel = FactoryComponentGeneratorHelper.getBuildModel(project_p);
        if (buildModel != null) {
            FactoryComponentGeneratorHelper.addEntryInBinaryBuild((IBuildModel)buildModel, entryName_p);
            buildModel.save();
        }
    }

    public void convertToFactoryComponent(String pluginId_p) {
        this.convertToFactoryComponent(pluginId_p, false);
    }

    public void convertToFactoryComponent(String pluginId_p, boolean makeItOptional_p) {
        boolean canBeConverted = ProjectHelper.canBeConvertedToFC((String)pluginId_p);
        if (!canBeConverted) {
            return;
        }
        FactoryComponentGeneratorHelper.addStandardFactoryComponentDependencies(pluginId_p, makeItOptional_p);
        String fcId = IDGeneratorHelper.generatePrefixUID((String)"factoryComponent");
        String productionPlanId = IDGeneratorHelper.generatePrefixUID((String)"productionPlan");
        String contractId = IDGeneratorHelper.generatePrefixUID((String)"contract");
        ArrayList<IPluginChangesCommand> commandsOnPlugin = new ArrayList<IPluginChangesCommand>(3);
        commandsOnPlugin.add(this.getFactoryComponentExtensionHelper().setFactoryComponentExtension(fcId, pluginId_p, contractId, null, productionPlanId, ""));
        commandsOnPlugin.add(this.getProductionPlanExtensionHelper().setProductionPlanExtension(productionPlanId, ""));
        commandsOnPlugin.add(this.getContractExtensionHelper().setContract(contractId));
        IPluginChangesCommandRunner changesCommandRunner = this.getPluginChangesCommandRunner();
        changesCommandRunner.performChangesOnPlugin(pluginId_p, commandsOnPlugin);
        FactoryComponentGeneratorHelper.addGeneratedSourceFolderIn(pluginId_p, true);
        FactoryComponentGeneratorHelper.addFolderIn(pluginId_p, "templates", true, (IProgressMonitor)new NullProgressMonitor());
        FactoryComponentGeneratorHelper.addFolderIn(pluginId_p, "model", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public boolean convertToPlugin(String projectName_p) {
        boolean result = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName_p);
        if (project == null) {
            return result;
        }
        ConvertProjectToPluginOperation convertOperation = new ConvertProjectToPluginOperation(new IProject[]{project});
        try {
            convertOperation.run((IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        catch (Exception exception_p1) {
            StringBuilder loggerMessage = new StringBuilder("EgfPdeActivator.convertToPlugin(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p1);
        }
        return result;
    }
}

