/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pde.reader;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.pde.internal.ui.util.ModelModification;
import org.eclipse.egf.pde.util.ExtensionHelper;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;

public abstract class CreateDescriptorOperation
extends ModelModification {
    private IDescriptor _descriptor;
    private String _readElementId;
    private IPluginModelBase _pluginModelBase;

    public CreateDescriptorOperation(IFile modelFile_p) {
        super(modelFile_p);
    }

    public CreateDescriptorOperation(IFile modelFile_p, String readExtensionId_p) {
        super(modelFile_p);
        this._readElementId = readExtensionId_p;
    }

    protected String getReadExtensionId() {
        return this._readElementId;
    }

    public IDescriptor getDescriptor() {
        return this._descriptor;
    }

    protected void modifyModel(IBaseModel model_p, IProgressMonitor monitor_p) throws CoreException {
        if (!(model_p instanceof IPluginModelBase)) {
            return;
        }
        this._descriptor = this.createDescriptor((IPluginModelBase)model_p);
    }

    protected abstract IDescriptor createDescriptor(IPluginModelBase var1);

    protected IPluginElement getExtensionWithId(IPluginModelBase model_p, String extensionPointId_p, String idValue_p) {
        IPluginElement result = null;
        IPluginExtension[] extensions = ExtensionHelper.getPluginExtension(model_p.getExtensions(), extensionPointId_p);
        int i = 0;
        while (i < extensions.length && result == null) {
            result = ExtensionHelper.getPluginElement((IPluginParent)extensions[i], "id", idValue_p);
            ++i;
        }
        return result;
    }

    protected IPluginElement[] getExtensionWithNodeName(IPluginModelBase model_p, String extensionPointId_p, String extensionChildNodeName_p) {
        IPluginExtension[] extensions;
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>();
        IPluginExtension[] iPluginExtensionArray = extensions = ExtensionHelper.getPluginExtension(model_p.getExtensions(), extensionPointId_p);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement[] elements;
            IPluginExtension pluginExtension = iPluginExtensionArray[n2];
            IPluginElement[] iPluginElementArray = elements = ExtensionHelper.getPluginElement((IPluginParent)pluginExtension, extensionChildNodeName_p);
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IPluginElement pluginElement = iPluginElementArray[n4];
                result.add(pluginElement);
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    protected IPluginElement[] getChildren(IPluginElement parent_p, String childNodeName_p) {
        IPluginElement[] allChildren = this.getChildren(parent_p);
        if (childNodeName_p == null || allChildren.length == 0) {
            return new IPluginElement[0];
        }
        ArrayList<IPluginElement> result = new ArrayList<IPluginElement>(0);
        IPluginElement[] iPluginElementArray = allChildren;
        int n = allChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement pluginElement = iPluginElementArray[n2];
            if (childNodeName_p.equals(pluginElement.getName())) {
                result.add(pluginElement);
            }
            ++n2;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    protected IPluginElement[] getChildren(IPluginElement parent_p) {
        IPluginObject[] children;
        ArrayList<IPluginElement> result = null;
        if (parent_p == null) {
            return new IPluginElement[0];
        }
        result = new ArrayList<IPluginElement>(0);
        IPluginObject[] iPluginObjectArray = children = parent_p.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement) {
                result.add((IPluginElement)pluginObject);
            }
            ++n2;
        }
        return result.toArray(new IPluginElement[result.size()]);
    }

    protected String getPluginAttributeValue(IPluginElement element_p, String attributeName_p) {
        IPluginAttribute attribute = element_p.getAttribute(attributeName_p);
        return attribute != null ? attribute.getValue() : null;
    }

    protected IFile getModelFile() {
        return this.getFile();
    }

    protected String readDescription(IPluginElement element_p) {
        String description = null;
        IPluginElement[] descriptions = this.getChildren(element_p, "description");
        if (descriptions.length > 0) {
            description = descriptions[0].getText();
        }
        return description;
    }

    protected IPluginModelBase getPluginModelBase() {
        return this._pluginModelBase;
    }

    public void setPluginModelBase(IPluginModelBase pluginModelBase_p) {
        this._pluginModelBase = pluginModelBase_p;
    }
}

