/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.workbench.internal.drop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.FactoryComponentInvocation;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.ProductionPlan;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.pde.EgfPdeActivator;
import org.eclipse.egf.pde.plugin.command.IPluginChangesCommand;
import org.eclipse.egf.pde.plugin.extension.IProductionPlanExtensionFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryComponentInvocationDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public IStatus handleDrop(CommonDropAdapter dropAdapter_p, DropTargetEvent dropTargetEvent_p, Object target_p) {
        IStatus result = Status.CANCEL_STATUS;
        List<FactoryComponentInvocation> movingFcInvocations = this.handleSelection();
        Object data = dropTargetEvent_p.item.getData();
        if (data instanceof FactoryComponentInvocation) {
            FactoryComponentInvocation fcInvocationAtDropLocation = (FactoryComponentInvocation)data;
            FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)fcInvocationAtDropLocation);
            ProductionPlan productionPlan = ModelHelper.getProductionPlan((FactoryComponent)fcContainer);
            ArrayList<FactoryComponentInvocation> allFcInvocations = new ArrayList<FactoryComponentInvocation>((Collection<FactoryComponentInvocation>)productionPlan.getFactoryComponentInvocations());
            if (!movingFcInvocations.contains(fcInvocationAtDropLocation)) {
                this.computeNewFcInvocationOrder(movingFcInvocations, dropTargetEvent_p.feedback, fcInvocationAtDropLocation, allFcInvocations);
                this.moveFcInvocations(productionPlan, allFcInvocations, fcContainer);
                result = Status.OK_STATUS;
            }
        }
        return result;
    }

    private void computeNewFcInvocationOrder(List<FactoryComponentInvocation> movingFcInvocations_p, int feedback_p, FactoryComponentInvocation fcInvocationAtDropLocation_p, List<FactoryComponentInvocation> allFcInvocations_p) {
        allFcInvocations_p.removeAll(movingFcInvocations_p);
        int acAtDropPosition = allFcInvocations_p.indexOf(fcInvocationAtDropLocation_p);
        int newPosition = -1;
        if (feedback_p == 4) {
            newPosition = acAtDropPosition + 1;
        } else if (feedback_p == 2) {
            newPosition = acAtDropPosition == 0 ? 0 : acAtDropPosition;
        }
        allFcInvocations_p.addAll(newPosition, movingFcInvocations_p);
    }

    private void moveFcInvocations(ProductionPlan productionPlan_p, List<FactoryComponentInvocation> allfcInvocations_p, FactoryComponent fcContainer_p) {
        EgfPdeActivator egfPdeActivator = EgfPdeActivator.getDefault();
        IProductionPlanExtensionFactory productionPlanExtensionFactory = egfPdeActivator.getProductionPlanExtensionHelper();
        String productionPlanId = productionPlan_p.getId();
        ArrayList<IPluginChangesCommand> unsetCommands = new ArrayList<IPluginChangesCommand>(1);
        ArrayList<IPluginChangesCommand> setCommands = new ArrayList<IPluginChangesCommand>(1);
        for (FactoryComponentInvocation fcInvocation : allfcInvocations_p) {
            unsetCommands.add(productionPlanExtensionFactory.unsetFactoryComponentInvocation(productionPlanId, fcInvocation.getId()));
            setCommands.add(productionPlanExtensionFactory.setFactoryComponentInvocation(productionPlanId, fcInvocation.getId()));
        }
        String pluginId = egfPdeActivator.getPluginIdForFactoryComponent(fcContainer_p.getId());
        ArrayList<IPluginChangesCommand> commands = new ArrayList<IPluginChangesCommand>(unsetCommands);
        commands.addAll(setCommands);
        egfPdeActivator.getPluginChangesCommandRunner().performChangesOnPlugin(pluginId, commands);
        productionPlan_p.eSet((EStructuralFeature)ModelPackage.Literals.PRODUCTION_PLAN__FACTORY_COMPONENT_INVOCATIONS, allfcInvocations_p);
    }

    public IStatus validateDrop(Object target_p, int operation_p, TransferData transferType_p) {
        IStatus result = null;
        List<FactoryComponentInvocation> selectedFcInvocations = this.handleSelection();
        switch (operation_p) {
            case 2: {
                result = selectedFcInvocations != null ? Status.OK_STATUS : Status.CANCEL_STATUS;
                break;
            }
            default: {
                result = Status.CANCEL_STATUS;
            }
        }
        return result;
    }

    private List<FactoryComponentInvocation> handleSelection() {
        List result = null;
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return result;
        }
        List selectedElements = ((IStructuredSelection)selection).toList();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return result;
        }
        FactoryComponent fcContainer = null;
        boolean isInterrupted = false;
        Iterator iterator = selectedElements.iterator();
        while (iterator.hasNext() && !isInterrupted) {
            Object object = iterator.next();
            if (!(object instanceof FactoryComponentInvocation)) {
                isInterrupted = true;
            }
            if (fcContainer == null) {
                fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)((NamedModelElementWithId)object));
                continue;
            }
            if (fcContainer.equals(ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)((NamedModelElementWithId)object)))) continue;
            isInterrupted = true;
        }
        result = !isInterrupted ? selectedElements : null;
        return result;
    }
}

