/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard;

import org.eclipse.egf.core.ui.wizard.AbstractModelElementWizard;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.ContractElementReferenceWizardPage;
import org.eclipse.egf.core.ui.wizard.page.ContractElementTypeWizardPage;
import org.eclipse.egf.core.ui.wizard.page.ContractElementWizardPage;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.FactoryComponent;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.data.helper.ModelHelper;
import org.eclipse.egf.model.edit.command.plugin.PluginChangeWrapperCommand;
import org.eclipse.egf.model.edit.command.plugin.contract.SetContractElementWrapperCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.wizard.IWizardPage;

public class ContractElementWizard
extends AbstractModelElementWizard {
    public static final String CONTRACT_ELEMENT_TYPE_PAGE = "contractElementTypePage";
    public static final String CONTRACT_ELEMENT_REFERENCE_PAGE = "contractElementReferencePage";
    protected static final String CONTRACT_ELEMENT_FIRST_PAGE = "contractElementPage";

    public ContractElementWizard(EObject parent_p, NamedModelElementWithId modelElement_p, boolean readOnlyMode_p) {
        super(parent_p, modelElement_p, readOnlyMode_p);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)new ContractElementWizardPage(CONTRACT_ELEMENT_FIRST_PAGE));
    }

    public IWizardPage getPage(String name_p) {
        Object page = super.getPage(name_p);
        if (page != null) {
            return page;
        }
        if (CONTRACT_ELEMENT_TYPE_PAGE.equals(name_p)) {
            page = new ContractElementTypeWizardPage(CONTRACT_ELEMENT_TYPE_PAGE);
        } else if (CONTRACT_ELEMENT_REFERENCE_PAGE.equals(name_p)) {
            page = new ContractElementReferenceWizardPage(CONTRACT_ELEMENT_REFERENCE_PAGE);
        }
        this.addPage((IWizardPage)page);
        return page;
    }

    protected boolean handleCanFinish() {
        return this.getContainer().getCurrentPage().isPageComplete();
    }

    public boolean performFinish() {
        ContractElement contractElement = (ContractElement)this.getModelElement();
        IWizardPage completingPage = this.getContainer().getCurrentPage();
        if (completingPage == this.getPage(CONTRACT_ELEMENT_TYPE_PAGE)) {
            contractElement.getContractElementReferences().clear();
        }
        return super.performFinish();
    }

    protected NamedModelElementWithId doCreateModelElement() {
        ContractElement createdContractElement = ModelFactory.eINSTANCE.createContractElement();
        FactoryComponent fcContainer = ModelHelper.getFactoryComponentContainer((NamedModelElementWithId)((NamedModelElementWithId)this.getParent()));
        createdContractElement.setFactoryComponentId(fcContainer.getId());
        return createdContractElement;
    }

    protected Command getAddCommandForCreatedElement(AdapterFactoryEditingDomain editingDomain_p, EObject parent_p, NamedModelElementWithId createdElement_p) {
        return AddCommand.create((EditingDomain)editingDomain_p, (Object)parent_p, (Object)ModelPackage.Literals.CONTRACT__CONTRACT_ELEMENTS, (Object)createdElement_p);
    }

    protected String getTitle() {
        return Messages.ContractElementWizard_Title;
    }

    protected String getCreationDescription() {
        return Messages.ContractElementWizard_CreateDescription_Message;
    }

    protected String getEditDescription() {
        return Messages.ContractElementWizard_EditDescription_Message;
    }

    protected PluginChangeWrapperCommand getPluginChangeCommand(EditingDomain editingDomain_p, EObject modelElement_p, EStructuralFeature feature_p, Object value_p) {
        return new SetContractElementWrapperCommand(editingDomain_p, modelElement_p, feature_p, value_p);
    }
}

