/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egf.common.ui.toolkit.widgets.handler.SelectionChangedHandler;
import org.eclipse.egf.common.ui.viewers.IContentHandler;
import org.eclipse.egf.common.ui.viewers.OrderedListViewer;
import org.eclipse.egf.common.ui.viewers.OrderedListViewerWithAddAndRemove;
import org.eclipse.egf.core.ui.internal.dialogs.ModelElementSelectionDialog;
import org.eclipse.egf.core.ui.internal.observable.IListViewerObserver;
import org.eclipse.egf.core.ui.internal.viewers.ObservablePatternElementContentProvider;
import org.eclipse.egf.core.ui.viewers.AdaptedModelElementLabelProvider;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.AbstractPatternElement;
import org.eclipse.egf.model.NamedModelElementWithId;
import org.eclipse.egf.model.PatternLibrary;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPatternLibrarySequenceWizardPage
extends AbstractModelElementWizardPage
implements IListViewerObserver {
    private static final int VIEWER_HEIGHT_IN_CHARS = 10;
    private static final int VIEWER_WIDTH_IN_CHARS = 60;
    private OrderedListViewer _orderedViewer;
    private IContentHandler _runtimeSequenceContentHandler;

    protected AbstractPatternLibrarySequenceWizardPage(String pageName_p) {
        super(pageName_p);
        this.initializeContentHandler();
    }

    public AbstractPatternLibrarySequenceWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
        this.initializeContentHandler();
    }

    private void initializeContentHandler() {
        this._runtimeSequenceContentHandler = new IContentHandler(){

            public Object createNewElement() {
                Object[] selection;
                Object pattern = null;
                ModelElementSelectionDialog selectionDialog = new ModelElementSelectionDialog(AbstractPatternLibrarySequenceWizardPage.this.getShell());
                selectionDialog.setTitle(Messages.AbstractPatternLibrarySequenceWizardPage_PatternElementSelectionDialog_Title);
                selectionDialog.setMessage(Messages.AbstractPatternLibrarySequenceWizardPage_PatternElementSelectionDialog_Message);
                selectionDialog.setMultipleSelection(false);
                selectionDialog.setElements(this.getDisplayedPatternElements());
                if (selectionDialog.open() == 0 && (selection = selectionDialog.getResult()) != null && selection.length > 0) {
                    pattern = selection[0];
                }
                return pattern;
            }

            private List<? extends NamedModelElementWithId> getDisplayedPatternElements() {
                ArrayList containedElements = new ArrayList(AbstractPatternLibrarySequenceWizardPage.this.getPatternLibrary().getPatternElements());
                containedElements.removeAll(AbstractPatternLibrarySequenceWizardPage.this.getFilteredPatternElements());
                return containedElements;
            }

            public void removeElement(Object element_p) {
            }
        };
    }

    protected List<Object> getFilteredPatternElements() {
        return Collections.emptyList();
    }

    protected OrderedListViewer createOrderedViewer(Composite parent_p) {
        return new OrderedListViewerWithAddAndRemove(parent_p){

            protected IContentHandler getContentHandler() {
                return AbstractPatternLibrarySequenceWizardPage.this._runtimeSequenceContentHandler;
            }

            protected SelectionChangedHandler createRemoveButtonHandler() {
                return new SelectionChangedHandler(){

                    protected boolean doHandleSelection(ISelection selection_p) {
                        return !selection_p.isEmpty();
                    }
                };
            }
        };
    }

    protected void initializeOrderedViewer(StructuredViewer decoratedViewer) {
        GridData data = (GridData)decoratedViewer.getControl().getLayoutData();
        data.widthHint = this.convertWidthInCharsToPixels(60);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        decoratedViewer.setLabelProvider((IBaseLabelProvider)new AdaptedModelElementLabelProvider(this.getAdapterFactory()));
    }

    protected void createPageArea(Composite parent_p) {
        this._orderedViewer = this.createOrderedViewer(parent_p);
        StructuredViewer decoratedViewer = this._orderedViewer.getDecoratedViewer();
        this.initializeOrderedViewer(decoratedViewer);
        ObservablePatternElementContentProvider observablePatternElementContentProvider = new ObservablePatternElementContentProvider();
        observablePatternElementContentProvider.addListViewerObserver(this);
        decoratedViewer.setContentProvider((IContentProvider)observablePatternElementContentProvider);
        List<Object> patternElementsOrder = this.getPatternElementsOrder();
        decoratedViewer.setInput(patternElementsOrder);
    }

    protected List<Object> getPatternElementsOrder() {
        List<Object> result = new ArrayList<Object>(0);
        String orchestration = this.getOrchestrationValue();
        if (orchestration != null && orchestration.length() > 0) {
            result = this.getPatternElements(orchestration);
        }
        return result;
    }

    protected abstract String getOrchestrationValue();

    protected abstract List<Object> getPatternElements(String var1);

    @Override
    public void elementAdded(List<Object> elements_p) {
    }

    @Override
    public void elementRemoved(List<Object> elements_p) {
    }

    protected boolean getCompleteStatus() {
        return true;
    }

    protected List<AbstractPatternElement> getPatternElements() {
        return this.getPatternLibrary().getPatternElements();
    }

    protected PatternLibrary getPatternLibrary() {
        return (PatternLibrary)this.getModelElement();
    }
}

