/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.wizard.page;

import org.eclipse.egf.common.ui.field.SpacerFieldEditor;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.helper.FieldEditorHelper;
import org.eclipse.egf.common.ui.helper.MessageFormatHelper;
import org.eclipse.egf.common.ui.toolkit.adapters.BooleanFieldEditorAdapter;
import org.eclipse.egf.common.ui.toolkit.fields.CRadioGroupFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.IFieldEditor;
import org.eclipse.egf.common.ui.toolkit.fields.ValidatingStringFieldEditor;
import org.eclipse.egf.common.ui.toolkit.validators.IValidator;
import org.eclipse.egf.common.ui.toolkit.validators.NotEmptyStringValidator;
import org.eclipse.egf.core.ui.internal.help.IHelpContextIds;
import org.eclipse.egf.core.ui.wizard.Messages;
import org.eclipse.egf.core.ui.wizard.page.AbstractModelElementWizardPage;
import org.eclipse.egf.model.ContractElement;
import org.eclipse.egf.model.ModelPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class ContractElementWizardPage
extends AbstractModelElementWizardPage {
    private static final String CONTRACT_ELEMENT_TYPE = String.valueOf(0);
    private static final String CONTRACT_ELEMENT_REFERENCE = String.valueOf(1);
    private static final int GROUP_NUM_COLUMNS = 2;
    private ValidatingStringFieldEditor _contractElementKeyFieldEditor;
    private CRadioGroupFieldEditor _typeGroup;
    private BooleanFieldEditorAdapter _checkBoxFieldEditor;

    public ContractElementWizardPage(String pageName_p) {
        super(pageName_p);
    }

    public ContractElementWizardPage(String pageName_p, String title_p, ImageDescriptor titleImage_p) {
        super(pageName_p, title_p, titleImage_p);
    }

    protected void createPageArea(Composite parent_p) {
        Group definitionGroup = FieldEditorHelper.createGroup((Composite)parent_p, null, (int)0, (int)2);
        this.createKeyFieldEditor((Composite)definitionGroup);
        this.createDescriptionFieldEditor((Composite)definitionGroup);
        new SpacerFieldEditor(parent_p);
        this.createTypeGroup(parent_p);
        this.createMandatoryCheckBox(parent_p);
        this.handlePageLayout(parent_p);
    }

    protected void handlePageLayout(Composite parent_p) {
        FieldEditorHelper.layoutFieldEditor((Composite)this._contractElementKeyFieldEditor.getValueControl().getParent(), (FieldEditor)this._contractElementKeyFieldEditor, (int)2);
        FieldEditorHelper.layoutFieldEditor((Composite)this._checkBoxFieldEditor.getValueControl().getParent(), (FieldEditor)this._checkBoxFieldEditor, (int)2);
        FieldEditorHelper.layoutFieldEditor((Composite)parent_p, (FieldEditor)this._typeGroup, (int)2);
    }

    private void createMandatoryCheckBox(Composite parent_p) {
        ContractElement contractElement = (ContractElement)this.getModelElement();
        Group options = FieldEditorHelper.createGroup((Composite)parent_p, (String)Messages.ContractElementWizardPage_OptionsGroup_Title, (int)0, (int)2);
        this._checkBoxFieldEditor = FieldEditorHelper.createCheckBoxFieldEditor((Composite)options, (DialogPage)this, (String)Messages.ContractElementWizardPage_OptionsGroup_Mandatory_Title, (String)Messages.ContractElementWizardPage_OptionsGroup_Mandatory_Tooltip, (boolean)contractElement.isMandatory(), (int)5, (int)5, (boolean)this.isReadOnly());
        DataBindingHelper.bindControlSelectionToProperty((Control)this._checkBoxFieldEditor.getValueControl(), (String)ModelPackage.Literals.CONTRACT_ELEMENT__MANDATORY.getName(), (Object)contractElement, null);
    }

    private void createTypeGroup(Composite parent_p) {
        ContractElement contractElement = (ContractElement)this.getModelElement();
        String[][] labelAndValues = new String[][]{{Messages.ContractElementWizardPage_TypeGroup_Type, CONTRACT_ELEMENT_TYPE}, {Messages.ContractElementWizardPage_TypeGroup_Reference, CONTRACT_ELEMENT_REFERENCE}};
        this._typeGroup = FieldEditorHelper.createRadioGroupFieldEditor((Composite)parent_p, (String)Messages.ContractElementWizardPage_TypeGroup_Title, (int)2, (String[][])labelAndValues, (boolean)this.isReadOnly());
        EList contractElementReferences = contractElement.getContractElementReferences();
        boolean hasReferencedContractElements = contractElementReferences != null && !contractElementReferences.isEmpty();
        String typeGroupSelection = hasReferencedContractElements ? CONTRACT_ELEMENT_REFERENCE : CONTRACT_ELEMENT_TYPE;
        this._typeGroup.selectRadioButtonFor((Object)typeGroupSelection);
    }

    private void createKeyFieldEditor(Composite parent_p) {
        this._contractElementKeyFieldEditor = FieldEditorHelper.createStringFieldEditor((Composite)parent_p, (DialogPage)this, (String)Messages.ContractElementWizardPage_Key_Title, (String)Messages.ContractElementWizardPage_Key_Tooltip, null, (int)-1, (IValidator)new NotEmptyStringValidator(Messages.ContractElementWizardPage_Key_ErrorMessage), (boolean)this.isReadOnly());
        Text key = this._contractElementKeyFieldEditor.getTextControl();
        key.setFocus();
        this.bindTextToAttribute(key, ModelPackage.Literals.NAMED_MODEL_ELEMENT_WITH_ID__NAME, this.getModelElement(), null);
        this._contractElementKeyFieldEditor.isValid(true);
    }

    private void createDescriptionFieldEditor(Composite parent_p) {
        String formattedTooltip = MessageFormatHelper.formatMessage((String)Messages.WizardPage_Description_Tooltip, (Object[])new String[]{Messages.ContractElementWizard_Title});
        IDocumentListener modificationHandler = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event_p) {
            }

            public void documentChanged(DocumentEvent event_p) {
                IDocument document = event_p.getDocument();
                String enteredText = document.get();
                ContractElementWizardPage.this.getModelElement().setDescription(enteredText);
            }
        };
        FieldEditorHelper.createDescriptionFieldEditor((Composite)parent_p, (String)Messages.WizardPage_Description_Title, (String)formattedTooltip, (String)this.getModelElement().getDescription(), (int)2, (IDocumentListener)modificationHandler, (boolean)this.isReadOnly());
    }

    protected boolean getCompleteStatus() {
        return false;
    }

    public boolean canFlipToNextPage() {
        IFieldEditor[] fieldEditors = new IFieldEditor[]{this._contractElementKeyFieldEditor};
        return this.handleFieldEditorValidation(fieldEditors);
    }

    public IWizardPage getNextPage() {
        IWizardPage result = null;
        Object radioButtonValue = this._typeGroup.getSelectedRadioButton();
        IWizard wizard = this.getWizard();
        if (CONTRACT_ELEMENT_TYPE.equals(radioButtonValue)) {
            result = wizard.getPage("contractElementTypePage");
        } else if (CONTRACT_ELEMENT_REFERENCE.equals(radioButtonValue)) {
            result = wizard.getPage("contractElementReferencePage");
        }
        return result;
    }

    protected String getPageTitle() {
        return Messages.ContractElementWizardPage_Title;
    }

    protected String getHelpContextId() {
        return IHelpContextIds.NEW_CONTRACT_ELEMENT_WIZARD_PAGE;
    }
}

