/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editor.page;

import org.apache.log4j.Logger;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.egf.common.helper.PatternHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.ui.helper.DataBindingHelper;
import org.eclipse.egf.common.ui.helper.FormHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pattern.ui.PatternUiActivator;
import org.eclipse.egf.pattern.ui.editor.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternBlock;
import org.eclipse.egf.pattern.ui.editor.page.AbstractPatternPage;
import org.eclipse.egf.pattern.ui.editor.page.Messages;
import org.eclipse.egf.pattern.ui.editor.page.util.DisplayHelper;
import org.eclipse.egf.pattern.ui.editor.util.PatternEditorPageLinkListener;
import org.eclipse.egf.pattern.ui.internal.editor.PatternEditorContentOutlinePage;
import org.eclipse.egf.pattern.ui.internal.editor.page.DefaultContentHandler;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PatternOverviewPage
extends AbstractPatternPage {
    static final Logger __logger = Logger.getLogger((String)PatternOverviewPage.class.getPackage().getName());
    private static final String INHERITANCE_IMAGE_KEY = "full/obj16/EGenericSuperType";
    protected static final String ID = "egf_pattern_overview_page";
    protected static final String HELP_CONTEXT_ID = String.valueOf(PatternUiActivator.getDefault().getPluginID()) + '.' + "egf_pattern_overview_page";

    public PatternOverviewPage(FormEditor editor_p) {
        super(editor_p, ID, Messages.PatternOverviewPage_Title);
        this.getExternalSelectionManager().addExternalHandlerFor(PatternEditorContentOutlinePage.PatternDataNode.class, this);
    }

    public void dispose() {
        super.dispose();
        this.getExternalSelectionManager().removeExternalHandler(this, PatternEditorContentOutlinePage.PatternDataNode.class);
    }

    public void handleSelection(Object firstSelectedObject_p, IStructuredSelection selection_p) {
        this.getEditor().setActivePage(ID);
    }

    protected AbstractPatternBlock createPatternBlock() {
        return null;
    }

    protected void doCreateFormContent(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p, IManagedForm managedForm_p) {
        FormHelper.updateCompositeLayoutWithLayoutType((Composite)parent_p, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
        this.createGeneralSection(toolkit_p, parent_p, patternData_p);
        this.createContentSection(toolkit_p, parent_p);
        if (this.isEditable() && this.getEditorInput() instanceof PatternEditorInput && ((PatternEditorInput)this.getEditorInput()).isDirty()) {
            this.setDirty(true);
        }
    }

    private void createGeneralSection(FormToolkit toolkit_p, Composite parent_p, PatternHandler.PatternData patternData_p) {
        GeneralInformationHandler handler = new GeneralInformationHandler(patternData_p);
        Couple generalCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)2, (boolean)false);
        Section generalSection = (Section)generalCouple.getKey();
        generalSection.setText(Messages.PatternOverviewPage_Section_GeneralInformation_Text);
        Composite generalComposite = (Composite)generalCouple.getValue();
        Label generalInformationLabel = toolkit_p.createLabel(generalComposite, Messages.PatternOverviewPage_Section_GeneralInformation_Description, 64);
        GridData gilData = new GridData(768);
        gilData.horizontalSpan = 2;
        generalInformationLabel.setLayoutData((Object)gilData);
        Text nameText = (Text)FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)generalComposite, (String)Messages.PatternOverviewPage_Pattern_LogicalName_Label, null, (boolean)this.isEditable()).getValue();
        AbstractPatternPage.TextValidator textValidator = new AbstractPatternPage.TextValidator(this, (Control)nameText){

            protected String getErrorMessageFor(String errorKey_p, String value_p) {
                if ("RegExp" == errorKey_p) {
                    return Messages.PatternOverviewPage_PatternNameErrorMessage;
                }
                return null;
            }
        };
        textValidator.setRegularExpression(org.eclipse.egf.core.ui.Messages.PatternOverviewPage_PatternNameRegularExpression);
        DataBindingHelper.bindTextToProperty((Control)nameText, (String)"patternLogicalName", (Object)handler, (IValueChangeListener)textValidator);
        FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)generalComposite, (String)Messages.PatternOverviewPage_Pattern_ParentLibrary_Id_Name_Label, (String)handler.getParentLibraryFullId(), (boolean)false);
        FormHelper.createLabelAndText((FormToolkit)toolkit_p, (Composite)generalComposite, (String)Messages.PatternOverviewPage_Pattern_Local_Id_Name_Label, (String)handler.getPatternLocalId(), (boolean)false);
        Couple descriptionCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)generalComposite, (int)64, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)true);
        Section descriptionSection = (Section)descriptionCouple.getKey();
        GridData dsData = (GridData)descriptionSection.getLayoutData();
        dsData.horizontalSpan = 2;
        descriptionSection.setText(Messages.PatternOverviewPage_Pattern_Description_Label);
        descriptionSection.setFont(nameText.getFont());
        descriptionSection.setForeground(toolkit_p.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        Composite descriptionComposite = (Composite)descriptionCouple.getValue();
        toolkit_p.createLabel(descriptionComposite, Messages.PatternOverviewPage_Pattern_Description_Description, 64);
        Composite textComposite = FormHelper.createCompositeWithLayoutType((FormToolkit)toolkit_p, (Composite)descriptionComposite, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)1, (boolean)true);
        int styles = 2882;
        Document document = new Document();
        document.set(handler.getPatternDescription());
        document.addDocumentListener((IDocumentListener)handler);
        SourceViewer textViewer = new SourceViewer(textComposite, null, this.isEditable() ? styles : styles | 8);
        textViewer.setDocument((IDocument)document);
        StyledText styledText = textViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        FormHelper.updateControlLayoutDataWithLayoutTypeData((Control)styledText, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT);
        FormHelper.forceControlSize((Control)textViewer.getControl(), (int)DisplayHelper.DEFAULT_TEXT_WIDTH_IN_CHARS, (int)DisplayHelper.DEFAULT_TEXT_HEIGHT_IN_CHARS);
    }

    private void createContentSection(FormToolkit toolkit_p, Composite parent_p) {
        int patternContentNumColumns = 2;
        Couple patternContentCouple = FormHelper.createSectionWithChildComposite((FormToolkit)toolkit_p, (Composite)parent_p, (int)320, (FormHelper.LayoutType)FormHelper.LayoutType.GRID_LAYOUT, (int)patternContentNumColumns, (boolean)false);
        Section patternContentSection = (Section)patternContentCouple.getKey();
        patternContentSection.setText(Messages.PatternOverviewPage_Section_PatternContent_Text);
        Composite patternContentComposite = (Composite)patternContentCouple.getValue();
        Label contentDescriptionLabel = toolkit_p.createLabel(patternContentComposite, Messages.PatternOverviewPage_Section_PatternContent_Description, 64);
        GridData cdlData = new GridData(768);
        cdlData.horizontalSpan = patternContentNumColumns;
        contentDescriptionLabel.setLayoutData((Object)cdlData);
        PatternEditorPageLinkListener listener = (PatternEditorPageLinkListener)((Object)this.getEditor().getAdapter(PatternEditorPageLinkListener.class));
        ImageRegistry jdtImageRegistry = JavaPlugin.getDefault().getImageRegistry();
        Image productionImage = jdtImageRegistry.get("org.eclipse.jdt.ui.jsearch_obj.gif");
        FormHelper.createLinkWithDescription((FormToolkit)toolkit_p, (Composite)patternContentComposite, (Image)productionImage, (String)Messages.PatternOverviewPage_Link_Production_Text, (Object)"egf_pattern_production_page", (String)Messages.PatternOverviewPage_Link_Production_Description, (IHyperlinkListener)listener);
        Image specificationImage = jdtImageRegistry.get("org.eclipse.jdt.ui.localvariable_obj.gif");
        FormHelper.createLinkWithDescription((FormToolkit)toolkit_p, (Composite)patternContentComposite, (Image)specificationImage, (String)Messages.PatternOverviewPage_Link_Specification_Text, (Object)"egf_pattern_specification_page", (String)Messages.PatternOverviewPage_Link_Specification_Description, (IHyperlinkListener)listener);
        Image inheritanceImage = ExtendedImageRegistry.INSTANCE.getImage(EcoreEditPlugin.INSTANCE.getImage(INHERITANCE_IMAGE_KEY));
        FormHelper.createLinkWithDescription((FormToolkit)toolkit_p, (Composite)patternContentComposite, (Image)inheritanceImage, (String)Messages.PatternOverviewPage_Link_Inheritance_Text, (Object)"egf_pattern_inheritance_page", (String)Messages.PatternOverviewPage_Link_Inheritance_Description, (IHyperlinkListener)listener);
        Image implementationImage = jdtImageRegistry.get("org.eclipse.jdt.ui.methpub_obj.gif");
        FormHelper.createLinkWithDescription((FormToolkit)toolkit_p, (Composite)patternContentComposite, (Image)implementationImage, (String)Messages.PatternOverviewPage_Link_Implementation_Text, (Object)"egf_pattern_implementation_page", (String)Messages.PatternOverviewPage_Link_Implementation_Description, (IHyperlinkListener)listener);
    }

    public String getHelpContextId() {
        return HELP_CONTEXT_ID;
    }

    private class GeneralInformationHandler
    extends DefaultContentHandler
    implements IDocumentListener {
        protected static final String DATA_BINDING_PATTERN_LOGICAL_NAME = "patternLogicalName";
        protected static final String DATA_BINDING_PATTERN_DESCRIPTION = "patternDescription";
        private String _parentLibraryFullId;
        private String _patternLocalId;

        protected GeneralInformationHandler(PatternHandler.PatternData patternData_p) {
            super(patternData_p, PatternOverviewPage.this);
            this.unmakePatternFullId();
        }

        public String getPatternLocalId() {
            return this._patternLocalId;
        }

        public void setPatternDescription(String newDescription_p) {
            this.getPattern().setDescription(newDescription_p);
            this.notifyModification();
        }

        public String getPatternDescription() {
            return this.getPattern().getDescription();
        }

        public void setPatternLogicalName(String newName_p) {
            String oldName;
            if (newName_p != null && !"".equals(newName_p.trim()) && !newName_p.equals(oldName = this.getPattern().getLogicalName())) {
                this.getPattern().setLogicalName(newName_p);
                this.notifyModification();
            }
        }

        public String getPatternLogicalName() {
            return this.getPattern().getLogicalName();
        }

        public String getParentLibraryFullId() {
            return this._parentLibraryFullId;
        }

        protected void unmakePatternFullId() {
            String patternFullId = this.getPattern().getId();
            Couple deresolvedId = PatternHelper.deresolveId((String)patternFullId);
            this._parentLibraryFullId = (String)deresolvedId.getKey();
            this._patternLocalId = (String)deresolvedId.getValue();
        }

        public void documentAboutToBeChanged(DocumentEvent event_p) {
        }

        public void documentChanged(DocumentEvent event_p) {
            IDocument document = event_p.getDocument();
            String newDescription = document.get();
            this.setPatternDescription(newDescription);
        }
    }
}

