/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.reader;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.ExtensionPointHelper;
import org.eclipse.egf.core.CoreActivator;
import org.eclipse.egf.core.reader.descriptor.ContextDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContextElementDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractElementDescriptor;
import org.eclipse.egf.core.reader.descriptor.ContractElementReferenceDescriptor;
import org.eclipse.egf.core.reader.descriptor.FactoryComponentDescriptor;
import org.eclipse.egf.core.reader.descriptor.FactoryComponentInvocationDescriptor;
import org.eclipse.egf.core.reader.descriptor.MappingDescriptor;
import org.eclipse.egf.core.reader.descriptor.ProductionPlanDescriptor;
import org.eclipse.egf.core.reader.descriptor.TaskFactoryDescriptor;
import org.eclipse.egf.core.task.ITaskFactory;
import org.eclipse.egf.model.ModelFactory;
import org.eclipse.egf.model.Type;
import org.eclipse.egf.model.contract.type.ITypeHolder;
import org.eclipse.egf.model.data.reader.descriptor.IFactoryComponentReader;

public class DefaultFactoryComponentReader
implements IFactoryComponentReader {
    public static final String PLUGIN_ID = CoreActivator.getDefault().getPluginID();

    private String readDescription(IConfigurationElement element_p) {
        String description = null;
        IConfigurationElement[] descriptions = element_p.getChildren("description");
        if (descriptions.length > 0) {
            description = descriptions[0].getValue();
        }
        return description;
    }

    public FactoryComponentDescriptor readFactoryComponent(String fcId_p) {
        return this.readFactoryComponent(ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"factoryComponent", (String)fcId_p));
    }

    public FactoryComponentDescriptor readFactoryComponent(IConfigurationElement factoryComponentConfigurationElement_p) {
        FactoryComponentDescriptor descriptor = null;
        if (factoryComponentConfigurationElement_p != null) {
            String productionPlanId;
            String contractId;
            String description;
            descriptor = new FactoryComponentDescriptor(this);
            descriptor.setId(ExtensionPointHelper.getId((IConfigurationElement)factoryComponentConfigurationElement_p));
            String fcName = factoryComponentConfigurationElement_p.getAttribute("name");
            if (fcName != null) {
                descriptor.setName(fcName);
            }
            if ((description = this.readDescription(factoryComponentConfigurationElement_p)) == null) {
                description = factoryComponentConfigurationElement_p.getValue();
            }
            descriptor.setDescription(description);
            String domainPath = factoryComponentConfigurationElement_p.getAttribute("domain");
            if (domainPath != null) {
                descriptor.setDomainPath(domainPath);
            }
            if ((contractId = factoryComponentConfigurationElement_p.getAttribute("contractId")) != null) {
                descriptor.setContractId(contractId);
            }
            if ((productionPlanId = factoryComponentConfigurationElement_p.getAttribute("productionPlanId")) != null) {
                descriptor.setProductionPlanId(productionPlanId);
            }
        }
        return descriptor;
    }

    public ProductionPlanDescriptor readProductionPlan(String productionPlanId_p, String fcId_p) {
        ProductionPlanDescriptor descriptor = null;
        IConfigurationElement productionPlanConfigurationElement = ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"productionPlan", (String)productionPlanId_p);
        if (productionPlanConfigurationElement != null) {
            descriptor = new ProductionPlanDescriptor(this);
            descriptor.setId(productionPlanId_p);
            String contextId = productionPlanConfigurationElement.getAttribute("contextId");
            if (contextId != null) {
                descriptor.setContextId(contextId);
            }
            IConfigurationElement[] fcInvocationElements = productionPlanConfigurationElement.getChildren("assetConfiguration");
            int i = 0;
            while (i < fcInvocationElements.length) {
                String fcInvocationId = fcInvocationElements[i].getAttribute("id");
                descriptor.addFactoryComponentInvocationId(fcInvocationId);
                ++i;
            }
        }
        return descriptor;
    }

    public FactoryComponentInvocationDescriptor readFactoryComponentInvocation(String factoryComponentInvocationId_p, String fcId_p) {
        FactoryComponentInvocationDescriptor descriptor = null;
        IConfigurationElement fcInvocationConfigurationElement = ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"assetConfiguration", (String)factoryComponentInvocationId_p);
        if (fcInvocationConfigurationElement != null) {
            String contextId;
            String taskFactoryId;
            descriptor = new FactoryComponentInvocationDescriptor(this);
            descriptor.setId(factoryComponentInvocationId_p);
            String fcInvocationName = fcInvocationConfigurationElement.getAttribute("name");
            descriptor.setName(fcInvocationName);
            String referencedFcId = fcInvocationConfigurationElement.getAttribute("assetId");
            if (referencedFcId != null) {
                descriptor.setReferencedFactoryComponentId(referencedFcId);
            }
            if ((taskFactoryId = fcInvocationConfigurationElement.getAttribute("taskFactoryId")) != null) {
                descriptor.setTaskFactoryId(taskFactoryId);
            }
            if ((contextId = fcInvocationConfigurationElement.getAttribute("contextId")) != null) {
                descriptor.setContextId(contextId);
            }
        }
        return descriptor;
    }

    public ContractDescriptor readContract(String contractId_p, String fcId_p) {
        ContractDescriptor descriptor = null;
        IConfigurationElement contractConfigurationElement = ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"contract", (String)contractId_p);
        if (contractConfigurationElement != null) {
            descriptor = new ContractDescriptor(this);
            descriptor.setId(contractId_p);
            IConfigurationElement[] contractElements = contractConfigurationElement.getChildren("contractElement");
            int i = 0;
            while (i < contractElements.length) {
                ContractElementDescriptor contractElementDescriptor = this.readContractElement(contractElements[i]);
                if (contractElementDescriptor != null) {
                    descriptor.addContractElementDescriptor(contractElementDescriptor);
                }
                ++i;
            }
        }
        return descriptor;
    }

    private ContractElementDescriptor readContractElement(IConfigurationElement contractElementConfigurationElement_p) {
        IConfigurationElement[] contractReferences;
        ContractElementDescriptor descriptor = new ContractElementDescriptor(this);
        descriptor.setId(contractElementConfigurationElement_p.getAttribute("id"));
        String contractElementName = contractElementConfigurationElement_p.getAttribute("name");
        descriptor.setContractElementName(contractElementName);
        ITypeHolder typeHolder = (ITypeHolder)ExtensionPointHelper.createInstance((IConfigurationElement)contractElementConfigurationElement_p, (String)"type");
        descriptor.setTypeHolder(typeHolder);
        descriptor.setTypeHolderClassName(typeHolder.getClass().getName());
        String mandatory = contractElementConfigurationElement_p.getAttribute("mandatory");
        boolean isMandatory = mandatory != null ? Boolean.parseBoolean(mandatory) : true;
        descriptor.setMandatory(isMandatory);
        String description = this.readDescription(contractElementConfigurationElement_p);
        if (description == null) {
            description = contractElementConfigurationElement_p.getValue();
        }
        descriptor.setDescription(description);
        IConfigurationElement[] iConfigurationElementArray = contractReferences = contractElementConfigurationElement_p.getChildren("contractElementRef");
        int n = contractReferences.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contractRef = iConfigurationElementArray[n2];
            String contractReferenceId = contractRef.getAttribute("contractElementReferenceId");
            descriptor.addContractReferenceId(contractReferenceId);
            ++n2;
        }
        return descriptor;
    }

    public ContextDescriptor readContext(String contextId_p, String fcId_p) {
        ContextDescriptor descriptor = null;
        IConfigurationElement contextConfigurationElement = ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"context", (String)contextId_p);
        if (contextConfigurationElement != null) {
            descriptor = new ContextDescriptor(this);
            descriptor.setId(contextId_p);
            IConfigurationElement[] contextElements = contextConfigurationElement.getChildren("contextElement");
            int i = 0;
            while (i < contextElements.length) {
                ContextElementDescriptor contextElementDescriptor = this.readContextElementDescriptor(contextElements[i]);
                if (contextElementDescriptor != null) {
                    descriptor.addContextElementDescriptor(contextElementDescriptor);
                }
                ++i;
            }
        }
        return descriptor;
    }

    private ContextElementDescriptor readContextElementDescriptor(IConfigurationElement contextElementConfigurationElement_p) {
        ContextElementDescriptor descriptor = new ContextElementDescriptor(this);
        descriptor.setId(contextElementConfigurationElement_p.getAttribute("id"));
        String pluginId = contextElementConfigurationElement_p.getContributor().getName();
        descriptor.setPluginId(pluginId);
        IConfigurationElement[] keyChild = contextElementConfigurationElement_p.getChildren("contractElementRef");
        if (keyChild.length > 0) {
            String contractReferenceId = keyChild[0].getAttribute("contractElementReferenceId");
            descriptor.setContractReferenceId(contractReferenceId);
        } else {
            keyChild = contextElementConfigurationElement_p.getChildren("key");
            if (keyChild.length > 0) {
                String key = keyChild[0].getAttribute("name");
                descriptor.setKey(key);
            }
        }
        String readableValue = null;
        IConfigurationElement[] valueChild = contextElementConfigurationElement_p.getChildren("contextValue");
        if (valueChild.length > 0) {
            Object typeHolder;
            readableValue = valueChild[0].getAttribute("value");
            String className = valueChild[0].getAttribute("class");
            if (className != null && (typeHolder = ExtensionPointHelper.createInstance((IConfigurationElement)valueChild[0], (String)"class")) != null) {
                Type type = ModelFactory.eINSTANCE.createType();
                type.setTypeHolder(typeHolder);
                type.setTypeHolderClassName(typeHolder.getClass().getName());
                descriptor.setType(type);
            }
        }
        descriptor.setReadableValue(readableValue);
        return descriptor;
    }

    public TaskFactoryDescriptor readTaskFactory(String taskFactoryId_p, String fcId_p) {
        TaskFactoryDescriptor descriptor = null;
        ITaskFactory taskFactory = (ITaskFactory)ExtensionPointHelper.createExecutableExtension((String)PLUGIN_ID, (String)"taskFactory", (String)taskFactoryId_p);
        if (taskFactory != null) {
            descriptor = new TaskFactoryDescriptor(this);
            descriptor.setId(taskFactoryId_p);
            descriptor.setTaskFactory(taskFactory);
            descriptor.setTaskFactoryClass(taskFactory.getClass().getName());
        }
        return descriptor;
    }

    public ContractElementReferenceDescriptor readContractElementReference(String contractReferenceId_p, String fcId_p) {
        ContractElementReferenceDescriptor descriptor = null;
        IConfigurationElement contractReference = ExtensionPointHelper.getConfigurationElement((String)PLUGIN_ID, (String)"contractReferences", (String)contractReferenceId_p);
        if (contractReference != null) {
            descriptor = new ContractElementReferenceDescriptor(this);
            descriptor.setId(contractReferenceId_p);
            String contractElementId = contractReference.getAttribute("referencedContractElementId");
            if (contractElementId != null) {
                descriptor.setContractElementId(contractElementId);
            } else {
                String contractElementName = contractReference.getAttribute("referencedContractElementName");
                descriptor.setContractElementName(contractElementName);
            }
            String referencedFcId = contractReference.getAttribute("referencedAssetId");
            descriptor.setReferencedFcId(referencedFcId);
        }
        return descriptor;
    }

    public IDescriptor readPatternLibraries(String fcId_p) {
        return null;
    }

    public IDescriptor readMappings(String fcId_p) {
        IConfigurationElement[] mappingConfigurationElements;
        MappingDescriptor result = new MappingDescriptor();
        if (fcId_p == null) {
            return result;
        }
        CoreActivator coreActivator = CoreActivator.getDefault();
        String pluginId = coreActivator.getPluginIdForFactoryComponent(fcId_p);
        IConfigurationElement[] iConfigurationElementArray = mappingConfigurationElements = ExtensionPointHelper.getConfigurationElements((String)PLUGIN_ID, (String)"mapping", (String)pluginId);
        int n = mappingConfigurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement mappingElement = iConfigurationElementArray[n2];
            MappingDescriptor currentMappingDescriptor = new MappingDescriptor();
            currentMappingDescriptor.setValue("id", ExtensionPointHelper.getId((IConfigurationElement)mappingElement));
            currentMappingDescriptor.setValue("name", mappingElement.getAttribute("name"));
            currentMappingDescriptor.setValue("path", mappingElement.getAttribute("path"));
            currentMappingDescriptor.setValue("assetIdAsSource", mappingElement.getAttribute("assetIdAsSource"));
            currentMappingDescriptor.setValue("assetIdAsTarget", mappingElement.getAttribute("assetIdAsTarget"));
            result.addChild((IDescriptor)currentMappingDescriptor);
            ++n2;
        }
        return result;
    }
}

