/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.jet.editor;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.jet.editor.JETEditorPlugin;
import org.eclipse.emf.codegen.jet.editor.JETURLClassLoader;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class JavaClassLoaderFactory {
    private Map classpathEntriesMap = new HashMap();
    private Map exportedClasspathEntriesMap = new HashMap();
    private HashSet exportedURLList;

    public URLClassLoader getClassloader(IJavaProject javaProject, ClassLoader parent) {
        Collection classpathEntries = this.getClasspathEntries(javaProject);
        ArrayList<File> classpathEntryFiles = new ArrayList<File>();
        Iterator iter = classpathEntries.iterator();
        while (iter.hasNext()) {
            URL entryURL = (URL)iter.next();
            if (!"file".equals(entryURL.getProtocol())) continue;
            File entryFile = new File(entryURL.getFile());
            classpathEntryFiles.add(entryFile);
        }
        File[] files = new File[classpathEntryFiles.size()];
        System.arraycopy(classpathEntryFiles.toArray(), 0, files, 0, files.length);
        JETURLClassLoader classLoader = new JETURLClassLoader(files, parent);
        return classLoader;
    }

    public URLClassLoader getClassloader(IJavaProject javaProject) {
        return this.getClassloader(javaProject, this.getClass().getClassLoader());
    }

    public Collection getClasspathEntries(IJavaProject javaProject) {
        if (this.classpathEntriesMap.get(javaProject) != null) {
            return (Collection)this.classpathEntriesMap.get(javaProject);
        }
        try {
            IPath baseAbsolutePath;
            if (!javaProject.exists()) {
                return Collections.EMPTY_LIST;
            }
            IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
            OrderedUniqueList urlList = new OrderedUniqueList();
            this.exportedURLList = new HashSet();
            IPath outputAbsolutePath = baseAbsolutePath = javaProject.getProject().getLocation();
            if (javaProject.getOutputLocation().segmentCount() > 1) {
                outputAbsolutePath = baseAbsolutePath.append(javaProject.getOutputLocation().removeFirstSegments(1));
            }
            URL outputURL = new URL("file", null, outputAbsolutePath.toString());
            urlList.add(outputURL);
            this.exportedURLList.add(outputURL);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                this.processEntry(urlList, entry);
                ++i;
            }
            this.exportedClasspathEntriesMap.put(javaProject, this.exportedURLList);
            this.classpathEntriesMap.put(javaProject, urlList);
            return urlList;
        }
        catch (JavaModelException e) {
            JETEditorPlugin.getDefault().log((Object)e);
        }
        catch (MalformedURLException e) {
            JETEditorPlugin.getDefault().log(e);
        }
        return null;
    }

    private void processEntry(List urlList, IClasspathEntry entry) throws MalformedURLException {
        String variableName;
        IPath variablePath;
        if (entry.getEntryKind() == 3) {
            IPath outputLocation = entry.getOutputLocation();
            if (outputLocation != null) {
                URL url = new URL("file", null, outputLocation.toString());
                this.exportedURLList.add(url);
                urlList.add(url);
            }
        } else if (entry.getEntryKind() == 2) {
            Collection refExp;
            IProject ijproject = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().segment(0));
            IJavaProject ref = JavaCore.create((IProject)ijproject);
            Collection cpEntries = this.getClasspathEntries(ref);
            if (entry.isExported() && (refExp = (Collection)this.exportedClasspathEntriesMap.get(ref)) != null) {
                this.exportedURLList.addAll(refExp);
            }
            urlList.addAll(cpEntries);
        } else if (entry.getEntryKind() == 5) {
            IPath entryPath = entry.getPath();
            URL url = new URL("file", null, entryPath.toString());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (res != null && res.exists()) {
                url = new URL("file", null, res.getLocation().toString());
            }
            if (entry.isExported()) {
                this.exportedURLList.add(url);
            }
            urlList.add(url);
        } else if (entry.getEntryKind() == 1) {
            IPath entryPath = entry.getPath();
            URL url = new URL("file", null, entryPath.toString());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(entryPath);
            if (res != null && res.exists()) {
                url = new URL("file", null, res.getLocation().toString());
            }
            if (entry.isExported()) {
                this.exportedURLList.add(url);
            }
            urlList.add(url);
        } else if (entry.getEntryKind() == 4 && (variablePath = JavaCore.getClasspathVariable((String)(variableName = entry.getPath().segment(0)))) != null) {
            URL url = new URL("file", null, variablePath.toString());
            if (entry.isExported()) {
                this.exportedURLList.add(url);
            }
            urlList.add(url);
        }
    }

    public Collection getCurrentExportedURLList() {
        return this.exportedURLList;
    }

    public void removeFromClassPathEntryMap(IJavaProject javaProject) {
        this.classpathEntriesMap.remove(javaProject);
    }

    public void clearCaches() {
        this.classpathEntriesMap.clear();
        this.exportedClasspathEntriesMap.clear();
    }

    public static URLClassLoader getClassLoader(IJavaProject javaProject) {
        JavaClassLoaderFactory factory = new JavaClassLoaderFactory();
        return factory.getClassloader(javaProject);
    }

    public static URLClassLoader getClassLoader(IJavaProject javaProject, ClassLoader parent) {
        JavaClassLoaderFactory factory = new JavaClassLoaderFactory();
        return factory.getClassloader(javaProject, parent);
    }

    private class OrderedUniqueList
    extends ArrayList {
        private static final long serialVersionUID = 1L;

        private OrderedUniqueList() {
        }

        public boolean add(Object element) {
            if (this.contains(element)) {
                return false;
            }
            return super.add(element);
        }
    }
}

