/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.fc.generator.javadoc.internal.task;

import com.sun.tools.javadoc.Main;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.ProjectHelper;
import org.eclipse.egf.fc.generator.javadoc.internal.task.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavadocGeneratorOperation
extends WorkspaceModifyOperation {
    private static final String JAVADOC_PACKAGE_NAME_SEPARATOR = " ";
    private static final String JAVADOC_CLASSPATH_SEPARATOR = ";";
    private static final String JAVADOC_AUTHOR_OPTION_FLAG = " -author ";
    private static final String JAVADOC_VERSION_OPTION_FLAG = " -version ";
    private static final String JAVADOC_USE_OPTION_FLAG = " -use ";
    private static final String SOURCE_VERSION_5_0 = "1.5";
    private static final String JAVADOC_SOURCE_VERSION_OPTION_FLAG = " -source ";
    private static final String JAVADOC_SCOPE_OPTION_FLAG = " -public ";
    private static final String JAVADOC_CLASSPATH_OPTION_FLAG = " -classpath ";
    private static final String JAVADOC_SOURCE_PATH_OPTION_FLAG = " -sourcepath ";
    private static final String JAVADOC_OUTPUT_FOLDER_SUFFIX = "/doc";
    private static final String JAVADOC_OUTPUT_FOLDER_OPTION_FLAG = " -d ";
    static final Logger __logger = Logger.getLogger((String)JavadocGeneratorOperation.class.getPackage().getName());
    private String _fcProjectName;
    private String _sourceDirectory;
    private boolean _result;
    private String _temporaryFilePath;
    private int _ticksCount;

    public JavadocGeneratorOperation(String fcProjectName_p, String sourceDirectory_p) {
        this._fcProjectName = fcProjectName_p;
        this._sourceDirectory = sourceDirectory_p;
    }

    private boolean doExecute(IProgressMonitor monitor_p) {
        String[] packageNames;
        boolean result = false;
        monitor_p.subTask(Messages.JavadocGeneratorOperation_ProgressReporting_Message);
        IJavaProject fcProject = ProjectHelper.getJavaProject((String)this._fcProjectName);
        if (fcProject == null) {
            StringBuffer loggerMessage = new StringBuffer("JavadocGeneratorOperation.doExecute(..) _ ");
            loggerMessage.append(this._fcProjectName);
            loggerMessage.append(" is not a java project. Javadoc can't be generated !");
            __logger.error((Object)loggerMessage.toString());
            return result;
        }
        String[] classPath = null;
        try {
            classPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)fcProject);
        }
        catch (CoreException exception_p) {
            StringBuffer loggerMessage = new StringBuffer("JavadocGeneratorOperation.doExecute(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        if (classPath == null || classPath.length <= 0) {
            return result;
        }
        StringBuffer parameters = new StringBuffer();
        parameters.append(JAVADOC_OUTPUT_FOLDER_OPTION_FLAG);
        parameters.append(this.getJavadocOutputFolder(this._fcProjectName));
        parameters.append(JAVADOC_SOURCE_PATH_OPTION_FLAG);
        parameters.append(this.getJavadocInputSourceFolder(this._fcProjectName, this._sourceDirectory));
        parameters.append(JAVADOC_CLASSPATH_OPTION_FLAG);
        String[] stringArray = classPath;
        int n = classPath.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            parameters.append(path).append(JAVADOC_CLASSPATH_SEPARATOR);
            ++n2;
        }
        parameters.deleteCharAt(parameters.length() - 1);
        parameters.append(JAVADOC_SCOPE_OPTION_FLAG);
        parameters.append(JAVADOC_SOURCE_VERSION_OPTION_FLAG);
        parameters.append(SOURCE_VERSION_5_0);
        parameters.append(JAVADOC_USE_OPTION_FLAG);
        parameters.append(JAVADOC_VERSION_OPTION_FLAG);
        parameters.append(JAVADOC_AUTHOR_OPTION_FLAG);
        String[] stringArray2 = packageNames = this.getPackageNames(fcProject);
        int n3 = packageNames.length;
        n = 0;
        while (n < n3) {
            String packageName = stringArray2[n];
            parameters.append(packageName).append(JAVADOC_PACKAGE_NAME_SEPARATOR);
            ++n;
        }
        try {
            try {
                String parametersFileName = this.createParametersFile(parameters.toString());
                String[] processArgs = new String[]{parametersFileName};
                Main.execute((String[])processArgs);
                this.deleteParametersFile();
                fcProject.getProject().refreshLocal(2, monitor_p);
            }
            catch (Exception exception_p) {
                StringBuffer loggerMessage = new StringBuffer("JavadocGeneratorOperation.doExecute(..) _ ");
                __logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
                monitor_p.worked(this._ticksCount);
            }
        }
        finally {
            monitor_p.worked(this._ticksCount);
        }
        return result;
    }

    private String createParametersFile(String parameters_p) throws Exception {
        this._temporaryFilePath = "";
        File file = File.createTempFile("javadoc-arguments", ".tmp");
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(parameters_p);
            this._temporaryFilePath = file.getAbsolutePath();
        }
        finally {
            writer.close();
        }
        return String.valueOf('@') + this._temporaryFilePath;
    }

    private void deleteParametersFile() {
        File parametersFile = new File(this._temporaryFilePath);
        if (parametersFile.exists() && parametersFile.isFile()) {
            parametersFile.delete();
            this._temporaryFilePath = null;
        }
    }

    private String[] getPackageNames(IJavaProject javaProject_p) {
        ArrayList<String> packageNames = new ArrayList<String>(0);
        try {
            IPackageFragmentRoot[] roots = javaProject_p.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.getKind() == 1) {
                    IJavaElement[] packs = root.getChildren();
                    int k = 0;
                    while (k < packs.length) {
                        IJavaElement curr = packs[k];
                        if (curr.getElementType() == 4) {
                            IPackageFragment packageFragment = (IPackageFragment)curr;
                            String packageName = curr.getElementName();
                            if (packageFragment.containsJavaResources() && packageName.length() > 0) {
                                packageNames.add(packageName);
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception_p) {
            StringBuffer loggerMessage = new StringBuffer("JavadocGeneratorOperation.getPackageNames(..) _ ");
            __logger.error((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return packageNames.toArray(new String[packageNames.size()]);
    }

    private String getJavadocOutputFolder(String fcProjectName_p) {
        return this.getResolvedAbsolutePath(String.valueOf(fcProjectName_p) + JAVADOC_OUTPUT_FOLDER_SUFFIX);
    }

    private String getJavadocInputSourceFolder(String fcProjectName_p, String sourceDirectory_p) {
        return this.getResolvedAbsolutePath(String.valueOf(fcProjectName_p) + this.ensurePath(sourceDirectory_p));
    }

    private String ensurePath(String sourceDirectory_p) {
        String result = null;
        result = sourceDirectory_p.startsWith(String.valueOf('/')) ? sourceDirectory_p : '/' + sourceDirectory_p;
        return result;
    }

    private String getResolvedAbsolutePath(String platformRelativePath_p) {
        String result = null;
        try {
            URL outputUrl = new URL("platform:/resource/" + platformRelativePath_p);
            URL resolvedOutputUrl = FileLocator.resolve((URL)outputUrl);
            result = resolvedOutputUrl.getFile();
        }
        catch (Exception exception_p) {
            StringBuffer loggerMessage = new StringBuffer("JavadocGeneratorOperation.getJavadocOutputFolder(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return result;
    }

    protected void execute(IProgressMonitor monitor_p) throws CoreException, InvocationTargetException, InterruptedException {
        this._result = this.doExecute(monitor_p);
    }

    public boolean getResult() {
        return this._result;
    }

    public void setTicksCount(int ticksCount_p) {
        this._ticksCount = ticksCount_p;
    }
}

