/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.production;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.descriptor.IDescriptor;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.pattern.Pattern;
import org.eclipse.egf.pattern.ecore.PatternConstants;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.egf.pde.pattern.reader.WorkspacePatternTemplateExtensionReader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedContentHelper {
    public static IFolder getPatternOutputPath(IProject project_p) {
        if (project_p == null) {
            return null;
        }
        IResource resource = project_p.findMember(PatternConstants.PATTERN_MODEL_FOLDER_IPATH);
        if (resource != null && resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return null;
    }

    public static IPath getBinaryOutputPatternGeneratedFolder(IJavaProject project_p) {
        if (project_p == null) {
            return null;
        }
        IPath path = null;
        try {
            path = project_p.getOutputLocation().append(FileHelper.convertPackageNameToFolderPath((String)"org.eclipse.egf.pattern"));
        }
        catch (JavaModelException javaModelException) {}
        return path;
    }

    public static String getPatternIdentifier(IFile element_p) {
        if (element_p == null || element_p.getFullPath() == null) {
            return null;
        }
        return StringHelper.replaceNonWordCharactersWithDot((String)element_p.getFullPath().removeFileExtension().lastSegment());
    }

    public static String getPatternClassName(Pattern pattern_p) {
        if (pattern_p == null) {
            return null;
        }
        return StringHelper.replaceNonWordCharactersWithUnderscore((String)pattern_p.getShortId());
    }

    public static String getPatternIdentifier(IFolder element_p) {
        if (element_p == null || element_p.getName() == null) {
            return null;
        }
        return StringHelper.replaceNonWordCharactersWithDot((String)StringHelper.toUpperFirst((String)element_p.getName()));
    }

    public static String getPatternPackageName(Pattern pattern_p) {
        if (pattern_p == null || pattern_p.getShortId() == null) {
            return null;
        }
        return StringHelper.replaceNonWordCharactersWithUnderscore((String)StringHelper.toLowerFirst((String)pattern_p.getShortId()));
    }

    public static String getPatternPackageNsPrefix(Pattern pattern_p) {
        return GeneratedContentHelper.getPatternPackageName(pattern_p);
    }

    public static String getPatternPackageNsURI(Pattern pattern_p) {
        if (pattern_p == null || pattern_p.getShortId() == null) {
            return null;
        }
        return "http://www.eclipse.org/egf/1.0.0/Pattern/Generated/" + pattern_p.getShortId();
    }

    public static String getEMFGeneratedRootFolderRelativePath(PatternHandler.PatternData patternData_p) {
        if (patternData_p == null) {
            return null;
        }
        IPath rootGeneratedPackageRelativePath = new Path(String.valueOf('/') + patternData_p.getPluginId()).append("/generated").append(String.valueOf('/') + FileHelper.convertPackageNameToFolderPath((String)("org.eclipse.egf.pattern." + GeneratedContentHelper.getPatternPackageName(patternData_p.getPattern()))));
        return rootGeneratedPackageRelativePath.toString();
    }

    public static List<String> getEMFGeneratedPackagesNames(PatternHandler.PatternData patternData_p) {
        List<String> result = Collections.emptyList();
        if (patternData_p == null) {
            return result;
        }
        result = new ArrayList<String>(3);
        String baseGeneratedPackageName = "org.eclipse.egf.pattern." + GeneratedContentHelper.getPatternPackageName(patternData_p.getPattern());
        result.add(baseGeneratedPackageName);
        result.add(String.valueOf(baseGeneratedPackageName) + ".impl");
        result.add(String.valueOf(baseGeneratedPackageName) + ".util");
        return result;
    }

    protected static Couple<String, String> getPatternTemplateClassDescription(PatternHandler.PatternData patternData_p) {
        Couple result = null;
        if (patternData_p == null) {
            return result;
        }
        IDescriptor classDescriptor = new WorkspacePatternTemplateExtensionReader().readPatternTemplateExtension(patternData_p.getJavaProject().getProject(), patternData_p.getPattern().getShortId());
        if (classDescriptor == null) {
            return result;
        }
        String templateClass = (String)classDescriptor.getValue("class");
        if (templateClass != null) {
            String className = StringHelper.substringAfter((char)'.', (String)templateClass);
            String packageName = StringHelper.substringBefore((char)'.', (String)templateClass);
            result = new Couple((Object)packageName, (Object)className);
        }
        return result;
    }

    public static String getGeneratedPatternClassRelativePath(PatternHandler.PatternData patternData_p) {
        Couple<String, String> generatedPatternClassDescription = GeneratedContentHelper.getPatternTemplateClassDescription(patternData_p);
        if (generatedPatternClassDescription == null) {
            return null;
        }
        IPath generatedPatternClassRelativePath = new Path(String.valueOf('/') + patternData_p.getPluginId()).append("/generated").append(String.valueOf('/') + FileHelper.convertPackageNameToFolderPath((String)((String)generatedPatternClassDescription.getKey()))).append(String.valueOf('/') + (String)generatedPatternClassDescription.getValue()).addFileExtension("java");
        return generatedPatternClassRelativePath.toString();
    }
}

