/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.production.template;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.common.misc.Couple;
import org.eclipse.egf.common.misc.PlatformLocationType;
import org.eclipse.egf.model.edit.helper.FactoryComponentHelper;
import org.eclipse.egf.pattern.ecore.PatternHandler;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateHelper {
    public static final String TEMPLATES_ROOT_PATH = "/templates/";
    public static final IPath TEMPLATES_ROOT_IPATH = new Path("templates");
    protected static final String GENERATED_TEMPLATES_PATH = "/templates/generated/";
    protected static final IPath GENERATED_TEMPLATES_IPATH = TEMPLATES_ROOT_IPATH.append("generated");

    public static IFolder getTemplateRootIFolder(IJavaProject javaProject_p) {
        if (javaProject_p == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject_p.getPath().append(TEMPLATES_ROOT_IPATH));
        if (resource != null && resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return null;
    }

    public static IFolder getGeneratedTemplateIFolder(IJavaProject javaProject_p) {
        if (javaProject_p == null) {
            return null;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(javaProject_p.getPath().append(GENERATED_TEMPLATES_IPATH));
        if (resource != null && resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return null;
    }

    public static IFolder getGeneratedPatternTemplateIFolder(IJavaProject javaProject_p, String patternShortId_p) {
        if (javaProject_p == null || patternShortId_p == null) {
            return null;
        }
        IFolder folder = TemplateHelper.getGeneratedTemplateIFolder(javaProject_p);
        if (folder == null) {
            return null;
        }
        IResource resource = folder.findMember(patternShortId_p);
        if (resource != null && resource instanceof IFolder) {
            return (IFolder)resource;
        }
        return null;
    }

    public static String getPatternTemplatePath(PatternHandler.PatternData patternData_p) {
        String result = null;
        if (patternData_p == null) {
            return result;
        }
        String templatePath = patternData_p.getProductionOptionsHandler().getPatternTemplatePath();
        if (templatePath != null && templatePath.trim().length() > 0) {
            IPath patternTemplatePath = patternData_p.getJavaProject().getPath();
            patternTemplatePath = patternTemplatePath.append(TEMPLATES_ROOT_PATH).append(templatePath);
            result = patternTemplatePath.toString();
        } else {
            result = TemplateHelper.computeTemplatePath(patternData_p.getPluginId(), GENERATED_TEMPLATES_PATH, patternData_p.getPattern().getShortId());
        }
        return result;
    }

    public static String readTemplateFile(String templateRelativePath_p) {
        String result = "";
        if (templateRelativePath_p == null) {
            return result;
        }
        String fcId = new Path(templateRelativePath_p).segment(0);
        String pluginId = FactoryComponentHelper.getPluginId((String)fcId, (PlatformLocationType)PlatformLocationType.WORKSPACE_THEN_TARGET_PLATFORM);
        if (pluginId == null) {
            pluginId = fcId;
        }
        String physicalTemplateRelativePath = TemplateHelper.getPhysicalRelativePath(templateRelativePath_p, pluginId);
        return FileHelper.readFile((String)physicalTemplateRelativePath);
    }

    public static String getPhysicalRelativePath(String logicalRelativePath_p) {
        String result = null;
        if (logicalRelativePath_p == null) {
            return result;
        }
        String fcId = new Path(logicalRelativePath_p).segment(0);
        String pluginId = FactoryComponentHelper.getPluginId((String)fcId, (PlatformLocationType)PlatformLocationType.WORKSPACE_THEN_TARGET_PLATFORM);
        if (pluginId == null) {
            pluginId = fcId;
        }
        return TemplateHelper.getPhysicalRelativePath(logicalRelativePath_p, pluginId);
    }

    public static String getPhysicalRelativePath(String logicalRelativePath_p, String pluginId_p) {
        String result = null;
        if (logicalRelativePath_p == null || pluginId_p == null) {
            return result;
        }
        IPath relativePath = new Path(logicalRelativePath_p).removeFirstSegments(1);
        return new Path(String.valueOf(pluginId_p)).append(relativePath).toString();
    }

    public static String getTemplateRelativePath(String patternShortId_p, String pluginId_p, String operationName_p, String operationId_p) {
        String result = null;
        if (patternShortId_p == null || pluginId_p == null || operationName_p == null) {
            return result;
        }
        if ("generateBody".equals(operationName_p)) {
            return result;
        }
        Couple<String, String> folderNames = TemplateHelper.getTemplatesFolderNames(patternShortId_p);
        String folderName = null;
        if ("generatePreMatching".equals(operationName_p) || "generatePostMatching".equals(operationName_p)) {
            folderName = (String)folderNames.getValue();
            result = TemplateHelper.computeTemplatePath(pluginId_p, folderName, operationName_p);
        } else if (operationId_p != null) {
            folderName = (String)folderNames.getKey();
            result = TemplateHelper.computeTemplatePath(pluginId_p, folderName, operationId_p);
        }
        return result;
    }

    private static Couple<String, String> getTemplatesFolderNames(String patternShortId_p) {
        if (patternShortId_p == null) {
            return null;
        }
        return new Couple((Object)(TEMPLATES_ROOT_PATH + patternShortId_p), (Object)(GENERATED_TEMPLATES_PATH + patternShortId_p));
    }

    public static Couple<String, String> getPatternTemplatesFolderRelativePaths(String patternShortId_p, String pluginId_p) {
        Couple<String, String> folderNames = TemplateHelper.getTemplatesFolderNames(patternShortId_p);
        if (folderNames == null) {
            return null;
        }
        return new Couple((Object)TemplateHelper.computeTemplateFolderPath(pluginId_p, (String)folderNames.getKey()), (Object)TemplateHelper.computeTemplateFolderPath(pluginId_p, (String)folderNames.getValue()));
    }

    private static String computeTemplatePath(String containingPluginId_p, String subFolderPath_p, String templateFileName_p) {
        return TemplateHelper.computeTemplateFolderPath(containingPluginId_p, subFolderPath_p) + '/' + templateFileName_p + '.' + "pt";
    }

    private static String computeTemplateFolderPath(String containingPluginId_p, String subFolderPath_p) {
        return new StringBuilder(47).append(containingPluginId_p).append(subFolderPath_p).toString();
    }
}

