/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.providers;

import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableObservableListContentProvider
extends ObservableListContentProvider {
    private TableViewer tableViewer;
    final AdapterImpl refresher = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (!(msg.getEventType() != 1 && msg.getEventType() != 2 || TableObservableListContentProvider.this.tableViewer == null || TableObservableListContentProvider.this.tableViewer.getTable() == null || TableObservableListContentProvider.this.tableViewer.getTable().isDisposed())) {
                TableObservableListContentProvider.this.tableViewer.refresh();
            }
        }
    };

    public TableObservableListContentProvider(TableViewer tableViewer) {
        this.tableViewer = tableViewer;
        this.addDisposeListener();
    }

    private void addDisposeListener() {
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = TableObservableListContentProvider.this.tableViewer.getTable().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem item = tableItemArray[n2];
                    Object object = item.getData();
                    TableObservableListContentProvider.this.removeAdapter(object);
                    ++n2;
                }
            }
        });
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        int i = 0;
        while (i < elements.length) {
            this.addAdapter(elements[i]);
            ++i;
        }
        return elements;
    }

    public void addAdapter(Object object) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            this.addIntoAdapters((EList<Adapter>)eAdapters);
            this.addChildAdapter(object);
        }
    }

    private void removeAdapter(Object object) {
        if (object instanceof EObject) {
            EList eAdapters = ((EObject)object).eAdapters();
            this.removeFromeAdapters((EList<Adapter>)eAdapters);
            this.removeChildAdapter(object);
        }
    }

    private void addChildAdapter(Object object) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            this.addIntoAdapters((EList<Adapter>)eAdapters);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            this.addIntoAdapters((EList<Adapter>)eAdapters);
        }
    }

    private void removeChildAdapter(Object object) {
        if (object instanceof MethodCall) {
            EList eAdapters = ((MethodCall)object).getCalled().eAdapters();
            this.removeFromeAdapters((EList<Adapter>)eAdapters);
        } else if (object instanceof PatternInjectedCall) {
            EList eAdapters = ((PatternInjectedCall)object).getContext().eAdapters();
            this.removeFromeAdapters((EList<Adapter>)eAdapters);
        }
    }

    private void addIntoAdapters(EList<Adapter> eAdapters) {
        if (!eAdapters.contains((Object)this.refresher)) {
            eAdapters.add((Object)this.refresher);
        }
    }

    private void removeFromeAdapters(EList<Adapter> eAdapters) {
        if (eAdapters.contains((Object)this.refresher)) {
            eAdapters.remove((Object)this.refresher);
        }
    }
}

