/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public class ProjectClassLoaderHelper {
    private static final Map<String, ClassLoader> classLoaders = new HashMap<String, ClassLoader>();

    public static ClassLoader getProjectClassLoader(IProject project) throws MalformedURLException, JavaModelException {
        String name = project.getName();
        ClassLoader classLoader = classLoaders.get(name);
        if (classLoader == null) {
            classLoader = new URLClassLoader(new URL[]{ProjectClassLoaderHelper.asURL(project)}, ProjectClassLoaderHelper.class.getClassLoader());
            classLoaders.put(name, classLoader);
        }
        return classLoader;
    }

    private static URL asURL(IProject project) throws MalformedURLException, JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPath outputLocation = javaProject.getOutputLocation();
        IFolder folder = project.getFolder(outputLocation.removeFirstSegments(1));
        return new URL("file", null, String.valueOf(folder.getLocation().toOSString()) + '/');
    }

    private ProjectClassLoaderHelper() {
    }
}

