/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.pde.internal.manifest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.egf.common.helper.MiscHelper;
import org.eclipse.egf.core.pde.plugin.AbstractManifestChangesCommand;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRequiredPluginsCommand
extends AbstractManifestChangesCommand {
    private String[] _requiredPlugins;

    public AbstractRequiredPluginsCommand(String[] requiredPlugins_p) {
        this._requiredPlugins = requiredPlugins_p;
    }

    @Override
    public void execute() {
        super.execute();
        IBundlePluginModel bundlePluginModel = this.getBundlePluginModel();
        List<IPluginImport> existingPluginImports = this.getExistingImports();
        String[] stringArray = this.getRequiredPlugins();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String requiredPlugin = stringArray[n2];
            this.handleRequiredPlugin(requiredPlugin, bundlePluginModel, existingPluginImports);
            ++n2;
        }
    }

    protected abstract void handleRequiredPlugin(String var1, IBundlePluginModel var2, List<IPluginImport> var3);

    protected IPluginImport pluginImportExists(String pluginImportId_p, List<IPluginImport> existingPluginImports_p) {
        IPluginImport result = null;
        Iterator<IPluginImport> imports = existingPluginImports_p.iterator();
        while (imports.hasNext() && result == null) {
            IPluginImport currentPluginImport = imports.next();
            if (!currentPluginImport.getId().equals(pluginImportId_p)) continue;
            result = currentPluginImport;
        }
        return result;
    }

    protected List<IPluginImport> getExistingImports() {
        ArrayList<IPluginImport> result = new ArrayList<IPluginImport>(0);
        IPluginBase pluginBase = this.getPluginModelBase().getPluginBase();
        result.addAll(MiscHelper.asList((Object[])pluginBase.getImports()));
        return result;
    }

    protected String[] getRequiredPlugins() {
        return this._requiredPlugins;
    }
}

