/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class URIHelper {
    public static final URI PLATFORM_PLUGIN_URI = URI.createURI((String)"platform:/plugin/");
    public static final URI PLATFORM_RESOURCE_URI = URI.createURI((String)"platform:/resource/");

    private URIHelper() {
    }

    public static URI getPlatformPluginURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isRelative()) {
            return URI.createPlatformPluginURI((String)uri.toString(), (boolean)false);
        }
        if (uri.isPlatformResource()) {
            return uri.replacePrefix(PLATFORM_RESOURCE_URI, PLATFORM_PLUGIN_URI);
        }
        return uri;
    }

    public static URI getPlatformResourceURI(URI uri) {
        if (uri == null) {
            return null;
        }
        if (uri.isRelative()) {
            return URI.createPlatformResourceURI((String)uri.toString(), (boolean)false);
        }
        if (uri.isPlatformResource()) {
            return uri.replacePrefix(PLATFORM_PLUGIN_URI, PLATFORM_RESOURCE_URI);
        }
        return uri;
    }

    public static URI getPlatformURI(IPluginModelBase model, String value) {
        if (model == null || value == null || value.trim().length() == 0) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(model);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformURI(bundleId, value.trim(), true);
    }

    public static URI getPlatformURI(IPath path) {
        if (path == null || path.segmentCount() < 2) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        if (project == null) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(project);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformURI(bundleId, path.removeFirstSegments(1).toString(), true);
    }

    public static URI getPlatformURI(IResource resource) {
        if (resource == null || resource.getFullPath() == null || resource.getFullPath().segmentCount() < 2) {
            return null;
        }
        String bundleId = BundleHelper.getBundleId(resource);
        if (bundleId == null) {
            return null;
        }
        return URIHelper.getPlatformURI(bundleId, resource.getFullPath().removeFirstSegments(1).toString(), true);
    }

    public static URI getPlatformURI(String bundleId, String value, boolean encode) {
        if (bundleId == null || bundleId.trim().length() == 0 || value == null || value.trim().length() == 0) {
            return null;
        }
        URI uri = URI.createURI((String)value.trim());
        if (uri.isRelative()) {
            uri = URI.createPlatformPluginURI((String)(String.valueOf(bundleId.trim()) + "/" + uri.toString()), (boolean)encode);
        }
        return uri;
    }
}

