/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui.diagnostic;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.ui.emf.EMFEditUIHelper;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EGFValidator {
    private Collection<? extends EObject> _eObjects = new ArrayList<EObject>();

    public EGFValidator(Collection<? extends EObject> eObjects) {
        this._eObjects = eObjects;
    }

    public Diagnostic validate() {
        final Diagnostic[] diagnostic = new Diagnostic[1];
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    diagnostic[0] = EGFValidator.this.validate(progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                return;
                            }
                            int severity = diagnostic[0].getSeverity();
                            if (severity == 4 || severity == 2) {
                                EGFValidator.handleDiagnostic(EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title"), EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message"), diagnostic[0]);
                            }
                        }
                    });
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        runnableWithProgress = new WorkspaceModifyDelegatingOperation(runnableWithProgress);
        try {
            new ProgressMonitorDialog(shell).run(true, true, runnableWithProgress);
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
        return diagnostic[0];
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor) {
        int selectionSize;
        int count = selectionSize = this._eObjects.size();
        for (EObject eObject : this._eObjects) {
            TreeIterator i = eObject.eAllContents();
            while (i.hasNext()) {
                ++count;
                i.next();
            }
        }
        progressMonitor.beginTask("", count);
        Diagnostician diagnostician = this.createDiagnostician(progressMonitor);
        BasicDiagnostic diagnostic = new BasicDiagnostic(EGFCoreUIPlugin.getDefault().getPluginID(), 0, EMFEditUIPlugin.INSTANCE.getString("_UI_DiagnosisOfNObjects_message", (Object[])new String[]{Integer.toString(selectionSize)}), this._eObjects.toArray());
        Map context = diagnostician.createDefaultContext();
        IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
        if (store.getBoolean("org.eclipse.egf.core.model.validate.types")) {
            context.put("org.eclipse.egf.core.model.validate.types", Boolean.TRUE);
        } else {
            context.put("org.eclipse.egf.core.model.validate.types", Boolean.FALSE);
        }
        ProjectBundleSession session = new ProjectBundleSession(EGFCoreUIPlugin.getDefault().getBundle().getBundleContext());
        context.put(ProjectBundleSession.PROJECT_BUNDLE_SESSION, session);
        for (EObject eObject : this._eObjects) {
            progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
            diagnostician.validate(eObject, (DiagnosticChain)diagnostic, context);
        }
        try {
            session.dispose();
        }
        catch (CoreException coreException) {
            EGFCoreUIPlugin.getDefault().logError(coreException);
        }
        return diagnostic;
    }

    protected Diagnostician createDiagnostician(final IProgressMonitor progressMonitor) {
        return new Diagnostician(){

            public String getObjectLabel(EObject eObject) {
                return EMFHelper.getText((Object)eObject);
            }

            public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
                progressMonitor.worked(1);
                return super.validate(eClass, eObject, diagnostics, context);
            }
        };
    }

    public static void handleDiagnostic(String title, String message, Diagnostic diagnostic) {
        List data;
        int result = 0;
        DiagnosticDialog dialog = new DiagnosticDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, message, diagnostic, 7);
        if (diagnostic.getSeverity() != 0) {
            result = dialog.open();
        }
        if (result == 0 && dialog.getSelection() != null && !(data = dialog.getSelection().getData()).isEmpty() && data.get(0) instanceof EObject) {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
            } else if (part instanceof IViewerProvider) {
                Viewer viewer = ((IViewerProvider)part).getViewer();
                if (viewer != null) {
                    viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                }
            } else {
                URI uri = EcoreUtil.getURI((EObject)((EObject)data.get(0)));
                try {
                    IEditorPart editorPart = EMFEditUIHelper.openEditor((URI)uri);
                    if (editorPart != null && editorPart instanceof IEditingDomainProvider) {
                        EMFEditUIHelper.setSelectionToViewer((IEditorPart)editorPart, (URI)uri);
                    }
                }
                catch (Throwable t) {
                    ThrowableHandler.handleThrowable((String)EGFCoreUIPlugin.getDefault().getPluginID(), (Throwable)t);
                }
            }
        }
    }
}

