/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.presentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.helper.ResourceHelper;
import org.eclipse.egf.core.pde.tools.ConvertProjectOperation;
import org.eclipse.egf.core.ui.wizard.WizardNewFileCreationPage;
import org.eclipse.egf.model.editor.EGFModelsEditorPlugin;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcoreFactory;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.fprod.FprodFactory;
import org.eclipse.egf.model.fprod.FprodPackage;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreModelWizard
extends Wizard
implements INewWizard {
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected FcorePackage fcorePackage = FcorePackage.eINSTANCE;
    protected FprodPackage fprodPackage = FprodPackage.eINSTANCE;
    protected FcoreFactory fcoreFactory = this.fcorePackage.getFcoreFactory();
    protected FprodFactory fprodFactory = this.fprodPackage.getFprodFactory();
    protected FcoreModelWizardNewFileCreationPage newFileCreationPage;
    protected FcoreModelWizardInitialObjectCreationPage initialObjectCreationPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(EGFModelsEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EGFModelsEditorPlugin.INSTANCE.getImage("full/wizban/NewFcore")));
        this.setNeedsProgressMonitor(true);
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            this.initialObjectNames.add(this.fcorePackage.getFactoryComponent().getName());
            this.initialObjectNames.add(this.fprodPackage.getTask().getName());
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.fcorePackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        if (eClass == null) {
            eClass = (EClass)this.fprodPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
            return this.fprodFactory.create(eClass);
        }
        return this.fcoreFactory.create(eClass);
    }

    public boolean performFinish() {
        final IFile modelFile = this.getModelFile();
        final Throwable[] throwable = new Throwable[1];
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)EGFModelsEditorPlugin.INSTANCE.getString("_UI_Wizard_createActivity"), (int)200);
                try {
                    try {
                        EObject rootObject = FcoreModelWizard.this.createInitialModel();
                        ConvertProjectOperation convertOperation = new ConvertProjectOperation(modelFile.getProject(), !(rootObject instanceof FactoryComponent), false){

                            public List<String> addDependencies() {
                                ArrayList<String> dependencies = new ArrayList<String>(1);
                                dependencies.add("org.eclipse.egf.model.fprod");
                                dependencies.add("org.eclipse.egf.pattern.fprod");
                                return dependencies;
                            }

                            public List<String> addSourceFolders() {
                                ArrayList<String> sourceFolders = new ArrayList<String>(1);
                                sourceFolders.add("src");
                                return sourceFolders;
                            }
                        };
                        FcoreModelWizard.this.getContainer().run(false, true, (IRunnableWithProgress)convertOperation);
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        Resource resource = ResourceHelper.createResource((ResourceSet)resourceSet, (IResource)modelFile);
                        if (rootObject != null) {
                            resource.getContents().add((Object)rootObject);
                        }
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", FcoreModelWizard.this.initialObjectCreationPage.getEncoding());
                        resource.save(options);
                    }
                    catch (Throwable t) {
                        throwable[0] = t;
                        subMonitor.done();
                    }
                }
                finally {
                    subMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (Throwable t) {
            throwable[0] = t;
        }
        if (throwable[0] == null) {
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
        }
        if (throwable[0] != null && !(throwable[0] instanceof InterruptedException)) {
            ThrowableHandler.handleThrowable((String)EGFModelsEditorPlugin.getPlugin().getBundle().getSymbolicName(), (Throwable)throwable[0]);
            return false;
        }
        return true;
    }

    public void addPages() {
        Object selectedElement;
        this.newFileCreationPage = new FcoreModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_label"));
        this.newFileCreationPage.setDescription(EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + "." + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + "." + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new FcoreModelWizardInitialObjectCreationPage("Whatever2");
        this.initialObjectCreationPage.setTitle(EGFModelsEditorPlugin.INSTANCE.getString("_UI_FcoreModelWizard_label"));
        this.initialObjectCreationPage.setDescription(EGFModelsEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    public IFile getModelFile() {
        return this.newFileCreationPage.getModelFile();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FcoreModelWizardInitialObjectCreationPage
    extends WizardPage {
        protected Combo initialObjectField;
        protected List<String> encodings;
        protected Combo encodingField;
        protected ModifyListener validator;

        public FcoreModelWizardInitialObjectCreationPage(String pageId) {
            super(pageId);
            this.validator = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    FcoreModelWizardInitialObjectCreationPage.this.setPageComplete(FcoreModelWizardInitialObjectCreationPage.this.validatePage());
                }
            };
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            Label containerLabel = new Label(composite, 16384);
            containerLabel.setText(EGFModelsEditorPlugin.INSTANCE.getString("_UI_ModelObject"));
            data = new GridData();
            data.horizontalAlignment = 4;
            containerLabel.setLayoutData((Object)data);
            this.initialObjectField = new Combo(composite, 2048);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            this.initialObjectField.setLayoutData((Object)data);
            for (String objectName : FcoreModelWizard.this.getInitialObjectNames()) {
                this.initialObjectField.add(this.getLabel(objectName));
            }
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.select(0);
            }
            this.initialObjectField.addModifyListener(this.validator);
            Label encodingLabel = new Label(composite, 16384);
            encodingLabel.setText(EGFModelsEditorPlugin.INSTANCE.getString("_UI_XMLEncoding"));
            GridData data2 = new GridData();
            data2.horizontalAlignment = 4;
            encodingLabel.setLayoutData((Object)data2);
            this.encodingField = new Combo(composite, 2048);
            data2 = new GridData();
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            this.encodingField.setLayoutData((Object)data2);
            for (String encoding : this.getEncodings()) {
                this.encodingField.add(encoding);
            }
            this.encodingField.select(0);
            this.encodingField.addModifyListener(this.validator);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        protected boolean validatePage() {
            return this.getInitialObjectName() != null && this.getEncodings().contains(this.encodingField.getText());
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible) {
                if (this.initialObjectField.getItemCount() == 1) {
                    this.initialObjectField.clearSelection();
                    this.encodingField.setFocus();
                } else {
                    this.encodingField.clearSelection();
                    this.initialObjectField.setFocus();
                }
            }
        }

        public String getInitialObjectName() {
            String label = this.initialObjectField.getText();
            for (String name : FcoreModelWizard.this.getInitialObjectNames()) {
                if (!this.getLabel(name).equals(label)) continue;
                return name;
            }
            return null;
        }

        public String getEncoding() {
            return this.encodingField.getText();
        }

        protected String getLabel(String typeName) {
            try {
                return EGFModelsEditorPlugin.INSTANCE.getString("_UI_" + typeName + "_type");
            }
            catch (MissingResourceException mre) {
                EGFModelsEditorPlugin.INSTANCE.log(mre);
                return typeName;
            }
        }

        protected Collection<String> getEncodings() {
            if (this.encodings == null) {
                this.encodings = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(EGFModelsEditorPlugin.INSTANCE.getString("_UI_XMLEncodingChoices"));
                while (stringTokenizer.hasMoreTokens()) {
                    this.encodings.add(stringTokenizer.nextToken());
                }
            }
            return this.encodings;
        }
    }

    public class FcoreModelWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        public FcoreModelWizardNewFileCreationPage(String pageId, IStructuredSelection selection) {
            super(pageId, selection);
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String extension = new Path(this.getFileName()).getFileExtension();
                if (extension == null || !FILE_EXTENSIONS.contains(extension)) {
                    String key = FILE_EXTENSIONS.size() > 1 ? "_WARN_FilenameExtensions" : "_WARN_FilenameExtension";
                    this.setErrorMessage(EGFModelsEditorPlugin.INSTANCE.getString(key, new Object[]{FORMATTED_FILE_EXTENSIONS}));
                    return false;
                }
                return true;
            }
            return false;
        }

        public IFile getModelFile() {
            return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
        }
    }
}

