/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.MethodCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.ParameterMatcher;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.jet.Messages;
import org.eclipse.egf.pattern.jet.engine.JetNatureHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.egf.pattern.utils.ParameterTypeHelper;
import org.eclipse.emf.common.util.EList;

public class JetAssemblyContentProvider
extends AssemblyContentProvider {
    public JetAssemblyContentProvider(Pattern pattern) {
        super(pattern, new JavaMethodGenerationHelper("stringBuffer"));
    }

    protected void call(PatternCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        this.content.append("<%");
        if (call.getParameterMatching().isEmpty()) {
            ParameterMatcher matcher = ParameterMatcher.create((Pattern)call.getPattern(), (Pattern)pattern);
            if (!matcher.matches()) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error7, (Object)call.getPattern().getName()));
            }
            for (Iterator key : matcher.getMatching().keySet()) {
                String called = PatternHelper.uniqueName((NamedModelElement)key);
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(key.getType())).append(" ").append(called).append(" = ").append(((PatternParameter)matcher.getMatching().get(key)).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        } else {
            for (Map.Entry binding : call.getParameterMatching()) {
                String called = PatternHelper.uniqueName((NamedModelElement)((NamedModelElement)binding.getKey()));
                this.content.append(ParameterTypeHelper.INSTANCE.getTypeLiteral(((PatternParameter)binding.getKey()).getType())).append(" ").append(called).append(" = ").append(((PatternParameter)binding.getValue()).getName()).append(";").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.executeWithInjection(\"").append(pattern.getID()).append("\", ").append(ctxName);
        for (PatternParameter parameter : pattern.getAllParameters()) {
            this.content.append(", ").append(PatternHelper.uniqueName((NamedModelElement)parameter));
        }
        this.content.append(");");
        this.content.append("%>");
    }

    protected void call(BackCall object) throws PatternException {
        this.content.append("<%");
        this.content.append("CallHelper.callBack(new CallbackContext(ictx)");
        EList allParameters = this.pattern.getAllParameters();
        for (PatternParameter parameter : allParameters) {
            this.content.append(", ").append(parameter.getName());
        }
        this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("%>");
    }

    protected void call(SuperCall call) throws PatternException {
        if (call.getPattern().getSuperPattern() == null) {
            return;
        }
        this.content.append("<%");
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("super.generate(").append(ctxName);
        for (PatternParameter parameter : this.pattern.getSuperPattern().getAllParameters()) {
            this.content.append(", ").append(parameter.getName());
        }
        this.content.append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("%>");
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String templateClassName = JetNatureHelper.getTemplateClassName(pattern);
        if (templateClassName == null) {
            throw new PatternException(Messages.assembly_error1);
        }
        this.content.append("<%");
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(ctxName).append(".setValue(").append("PatternContext.INJECTED_CONTEXT, ").append(call.getContext().getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.execute(\"").append(pattern.getID()).append("\", ").append(ctxName).append(");").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("%>");
    }

    protected void call(MethodCall object) throws PatternException {
        this.content.append("<%").append(EGFCommonConstants.LINE_SEPARATOR);
        this.javaMethodHelper.addCallStatement(object.getCalled());
        this.content.append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void addMethodBodies() throws PatternException {
        this.content.append("<%").append("//Start of methods").append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
        for (PatternMethod method : PatternHelper.getUserMethds((Pattern)this.pattern)) {
            this.content.append("<%");
            this.javaMethodHelper.addSignature(method);
            this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR).append("%>");
            this.content.append(this.getMethodContent(method));
            this.content.append("<%}%>").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("<%").append("//End of methods").append("%>").append(EGFCommonConstants.LINE_SEPARATOR);
    }
}

