/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Properties;

public abstract class PublicKeyKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    public static final String SESSION_KEY_OBFUSCATION_PROPERTY = "org.bouncycastle.openpgp.session_key_obfuscation";
    public static final long WILDCARD = 0L;
    private PGPPublicKey pubKey;
    protected boolean sessionKeyObfuscation;
    protected boolean useWildcardKeyID;

    private static boolean getSessionKeyObfuscationDefault() {
        return !Properties.isOverrideSetTo((String)SESSION_KEY_OBFUSCATION_PROPERTY, (boolean)false);
    }

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            case 22: 
            case 27: 
            case 28: {
                throw new IllegalArgumentException("Can't use EdDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pGPPublicKey.getAlgorithm());
            }
        }
        this.pubKey = pGPPublicKey;
        this.sessionKeyObfuscation = PublicKeyKeyEncryptionMethodGenerator.getSessionKeyObfuscationDefault();
    }

    public PublicKeyKeyEncryptionMethodGenerator setSessionKeyObfuscation(boolean bl) {
        this.sessionKeyObfuscation = bl;
        return this;
    }

    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardKeyID(boolean bl) {
        this.useWildcardKeyID = bl;
        return this;
    }

    public byte[][] processSessionInfo(byte[] byArray) throws PGPException {
        byte[][] byArrayArray;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                byArrayArray = new byte[][]{this.convertToEncodedMPI(byArray)};
                break;
            }
            case 16: 
            case 20: {
                byte[] byArray2 = new byte[byArray.length / 2];
                byte[] byArray3 = new byte[byArray.length / 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
                byArrayArray = new byte[][]{this.convertToEncodedMPI(byArray2), this.convertToEncodedMPI(byArray3)};
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                byArrayArray = new byte[][]{byArray};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return byArrayArray;
    }

    private byte[] convertToEncodedMPI(byte[] byArray) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, byArray)).getEncoded();
        }
        catch (IOException iOException) {
            throw new PGPException("Invalid MPI encoding: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public ContainedPacket generate(int n, byte[] byArray) throws PGPException {
        long l = this.useWildcardKeyID ? 0L : this.pubKey.getKeyID();
        return PublicKeyEncSessionPacket.createV3PKESKPacket(l, this.pubKey.getAlgorithm(), this.processSessionInfo(this.encryptSessionInfo(this.pubKey, byArray)));
    }

    @Override
    public ContainedPacket generateV5(int n, int n2, byte[] byArray) throws PGPException {
        return null;
    }

    @Override
    public ContainedPacket generateV6(int n, int n2, byte[] byArray) throws PGPException {
        return null;
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2) throws PGPException;

    protected static byte[] getSessionInfo(byte[] byArray, byte[] byArray2) throws IOException {
        byte[] byArray3 = new MPInteger(new BigInteger(1, byArray)).getEncoded();
        byte[] byArray4 = new byte[byArray3.length + 1 + byArray2.length];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray3.length] = (byte)byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, byArray3.length + 1, byArray2.length);
        return byArray4;
    }

    protected static byte[] getSessionInfo(byte[] byArray, int n, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + 2 + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = (byte)(byArray2.length + 1);
        byArray3[byArray.length + 1] = (byte)n;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 2, byArray2.length);
        return byArray3;
    }
}

