/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.FileBasedChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.CompositeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.util.ChangePackageSplittingIterator;
import org.eclipse.emf.emfstore.server.ESCloseableIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChangePackageUtil {
    private ChangePackageUtil() {
    }

    public static AbstractChangePackage createChangePackage(boolean useInMemoryChangePackage) {
        if (useInMemoryChangePackage) {
            return VersioningFactory.eINSTANCE.createChangePackage();
        }
        FileBasedChangePackage fileBasedChangePackage = VersioningFactory.eINSTANCE.createFileBasedChangePackage();
        fileBasedChangePackage.initialize(FileUtil.createLocationForTemporaryChangePackage());
        return fileBasedChangePackage;
    }

    public static Iterator<ChangePackageEnvelope> splitChangePackage(FileBasedChangePackage changePackage, int changePackageFragmentSize) {
        return new ChangePackageSplittingIterator(changePackageFragmentSize, changePackage);
    }

    public static int countLeafOperations(Collection<AbstractOperation> operations) {
        int ret = 0;
        for (AbstractOperation operation : operations) {
            if (operation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)operation);
                continue;
            }
            ++ret;
        }
        return ret;
    }

    public static int countLeafOperations(AbstractOperation operation) {
        return ChangePackageUtil.countLeafOperations(Collections.singleton(operation));
    }

    public static int countLeafOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            ESCloseableIterable<AbstractOperation> operations = changePackage.operations();
            try {
                for (AbstractOperation operation : operations.iterable()) {
                    count += ChangePackageUtil.countLeafOperations(operation);
                }
            }
            finally {
                operations.close();
            }
        }
        return count;
    }

    public static int countOperations(List<AbstractChangePackage> changePackages) {
        int count = 0;
        for (AbstractChangePackage changePackage : changePackages) {
            count += changePackage.size();
        }
        return count;
    }

    private static int getSize(CompositeOperation compositeOperation) {
        int ret = 0;
        EList<AbstractOperation> subOperations = compositeOperation.getSubOperations();
        for (AbstractOperation abstractOperation : subOperations) {
            if (abstractOperation instanceof CompositeOperation) {
                ret += ChangePackageUtil.getSize((CompositeOperation)abstractOperation);
                continue;
            }
            ++ret;
        }
        return ret;
    }
}

