/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.core.helper;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.server.core.MonitorProvider;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACGroup;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnit;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.roles.Role;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGroupImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESUserImpl;
import org.eclipse.emf.emfstore.server.auth.ESOrgUnitResolver;
import org.eclipse.emf.emfstore.server.model.ESGroup;
import org.eclipse.emf.emfstore.server.model.ESOrgUnit;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitId;
import org.eclipse.emf.emfstore.server.model.ESOrgUnitProvider;
import org.eclipse.emf.emfstore.server.model.ESUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ACHelper {
    private ACHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<ACOrgUnit<?>> getOrgUnit(ESOrgUnitProvider orgUnitProvider, ESOrgUnitId orgUnitId) {
        Preconditions.checkNotNull((Object)orgUnitId, (Object)"orgUnitId must not be null");
        ACOrgUnitId internalId = (ACOrgUnitId)APIUtil.toInternal(ACOrgUnitId.class, (Object)orgUnitId);
        Object object = MonitorProvider.getInstance().getMonitor();
        synchronized (object) {
            ACUser internalAPI;
            for (ESUser user : orgUnitProvider.getUsers()) {
                internalAPI = (ACUser)((ESUserImpl)ESUserImpl.class.cast(user)).toInternalAPI();
                if (!internalAPI.getId().equals(internalId)) continue;
                return Optional.of((Object)internalAPI);
            }
            for (ESGroup group : orgUnitProvider.getGroups()) {
                internalAPI = (ACGroup)((ESGroupImpl)ESGroupImpl.class.cast(group)).toInternalAPI();
                if (!internalAPI.getId().equals(internalId)) continue;
                return Optional.of((Object)internalAPI);
            }
            return Optional.absent();
        }
    }

    public static List<Role> getAllRoles(ESOrgUnitResolver orgUnitResolver, ACOrgUnit<?> internalOrgUnit) {
        ESOrgUnit orgUnit = (ESOrgUnit)internalOrgUnit.toAPI();
        List groups = APIUtil.toInternal(orgUnitResolver.getGroups(orgUnit));
        ArrayList<Role> roles = new ArrayList<Role>();
        for (ACGroup group : groups) {
            roles.addAll((Collection<Role>)group.getRoles());
        }
        roles.addAll((Collection<Role>)internalOrgUnit.getRoles());
        return roles;
    }
}

