/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.server.conflictDetection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.server.conflictDetection.ConflictDetectionStrategy;
import org.eclipse.emf.emfstore.server.conflictDetection.IndexSensitiveConflictDetectionStrategy;
import org.eclipse.emf.emfstore.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictDetector {
    private ConflictDetectionStrategy conflictDetectionStrategy;

    public ConflictDetector() {
        this(new IndexSensitiveConflictDetectionStrategy());
    }

    public ConflictDetector(ConflictDetectionStrategy conflictDetectionStrategy) {
        this.conflictDetectionStrategy = conflictDetectionStrategy;
    }

    public boolean doConflict(ChangePackage changePackageA, ChangePackage changePackageB) {
        for (AbstractOperation operation : changePackageA.getOperations()) {
            for (AbstractOperation otherOperation : changePackageB.getOperations()) {
                if (!this.doConflict(operation, otherOperation)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doConflict(AbstractOperation operation, AbstractOperation otherOperation) {
        return this.conflictDetectionStrategy.doConflict(operation, otherOperation);
    }

    public boolean doConflict(ChangePackage changePackage, List<ChangePackage> changePackageList) {
        for (ChangePackage b : changePackageList) {
            if (!this.doConflict(changePackage, b)) continue;
            return true;
        }
        return false;
    }

    public Set<AbstractOperation> getConflicting(List<AbstractOperation> ops, List<AbstractOperation> otherOps) {
        HashSet<AbstractOperation> conflicting = new HashSet<AbstractOperation>();
        for (AbstractOperation position : ops) {
            for (AbstractOperation other : otherOps) {
                if (conflicting.contains(other) || !this.conflictDetectionStrategy.doConflict(position, other)) continue;
                conflicting.addAll(this.getRequiring(otherOps, other));
                conflicting.add(other);
            }
        }
        return conflicting;
    }

    public Set<AbstractOperation> getConflictingIndexIntegrity(List<AbstractOperation> ops, List<AbstractOperation> otherOps) {
        HashSet<AbstractOperation> conflicting = new HashSet<AbstractOperation>();
        IndexSensitiveConflictDetectionStrategy indexSensitiveStrategy = new IndexSensitiveConflictDetectionStrategy();
        for (AbstractOperation position : ops) {
            for (AbstractOperation other : otherOps) {
                if (conflicting.contains(other) || !indexSensitiveStrategy.doConflictIndexIntegrity(position, other)) continue;
                conflicting.addAll(this.getRequiring(otherOps, other));
                conflicting.add(other);
            }
        }
        return conflicting;
    }

    public List<AbstractOperation> getRequired(List<AbstractOperation> ops, AbstractOperation op) throws IllegalArgumentException {
        if (!ops.contains(op)) {
            throw new IllegalArgumentException("the ops list dos not contain op");
        }
        ArrayList<AbstractOperation> required = new ArrayList<AbstractOperation>();
        required.add(op);
        int i = ops.indexOf(op) - 1;
        while (i >= 0) {
            AbstractOperation current = ops.get(i);
            for (AbstractOperation req : required) {
                if (!this.conflictDetectionStrategy.isRequired(current, req)) continue;
                required.add(0, current);
                break;
            }
            --i;
        }
        required.remove(op);
        return required;
    }

    public List<AbstractOperation> getRequiring(List<AbstractOperation> ops, AbstractOperation op) {
        if (!ops.contains(op)) {
            throw new IllegalArgumentException("the ops list dos not contain op");
        }
        int opIdx = ops.indexOf(op);
        ArrayList<AbstractOperation> requiring = new ArrayList<AbstractOperation>();
        requiring.add(op);
        block0: for (AbstractOperation current : ops) {
            if (ops.indexOf(current) <= opIdx) continue;
            for (AbstractOperation req : requiring) {
                if (!this.conflictDetectionStrategy.isRequired(req, current)) continue;
                requiring.add(current);
                continue block0;
            }
        }
        requiring.remove(op);
        return requiring;
    }

    public Set<AbstractOperation> getAllConflictInvolvedOperations(List<AbstractOperation> operationListA, List<AbstractOperation> operationListB) {
        List<AbstractOperation> reqAoperations;
        Set<AbstractOperation> conflicting;
        HashSet<AbstractOperation> result = new HashSet<AbstractOperation>();
        for (AbstractOperation operationA : operationListA) {
            if (result.contains(operationA) || (conflicting = this.getConflicting(reqAoperations = this.getRequiring(operationListA, operationA), operationListB)).size() <= 0) continue;
            result.addAll(conflicting);
            result.add(operationA);
        }
        for (AbstractOperation operationB : operationListB) {
            if (result.contains(operationB) || (conflicting = this.getConflicting(reqAoperations = this.getRequiring(operationListB, operationB), operationListA)).size() <= 0) continue;
            result.addAll(conflicting);
            result.add(operationB);
        }
        return result;
    }

    public void filterToConflictInvolved(ChangePackage myChanges, List<ChangePackage> theirChanges) {
        ArrayList<AbstractOperation> theirOperations = new ArrayList<AbstractOperation>();
        for (ChangePackage theirChangePackage : theirChanges) {
            for (AbstractOperation theirOperation : theirChangePackage.getOperations()) {
                theirOperations.add(theirOperation);
            }
        }
        EList myOperations = myChanges.getOperations();
        Set<AbstractOperation> allConflictInvolvedOperations = this.getAllConflictInvolvedOperations((List<AbstractOperation>)myOperations, theirOperations);
        HashSet<AbstractOperation> myOperationsToRemove = new HashSet<AbstractOperation>();
        for (AbstractOperation myOperation : myOperations) {
            if (allConflictInvolvedOperations.contains(myOperation)) continue;
            myOperationsToRemove.add(myOperation);
        }
        myOperations.removeAll(myOperationsToRemove);
        ArrayList<ChangePackage> changePackagesToRemove = new ArrayList<ChangePackage>();
        for (ChangePackage theirChangePackage : theirChanges) {
            HashSet<AbstractOperation> theirOperationsToRemove = new HashSet<AbstractOperation>();
            EList theirOperations2 = theirChangePackage.getOperations();
            for (AbstractOperation theirOperation : theirOperations2) {
                if (allConflictInvolvedOperations.contains(theirOperation)) continue;
                theirOperationsToRemove.add(theirOperation);
            }
            theirOperations2.removeAll(theirOperationsToRemove);
            if (theirOperations2.size() != 0) continue;
            changePackagesToRemove.add(theirChangePackage);
        }
        theirChanges.removeAll(changePackagesToRemove);
    }
}

