/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.navigator.handler;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.commands.ECPCommand;
import org.eclipse.emf.ecp.common.model.ECPWorkspaceManager;
import org.eclipse.emf.ecp.common.model.workSpaceModel.ECPProject;
import org.eclipse.emf.ecp.common.util.PreferenceHelper;
import org.eclipse.emf.ecp.common.util.UiUtil;
import org.eclipse.emf.ecp.navigator.Activator;
import org.eclipse.emf.emfstore.common.CommonUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportModelHandler
extends AbstractHandler {
    public static final String[] FILTER_EXTS = new String[]{"*.ecm", "*.*"};
    public static final String[] FILTER_NAMES = new String[]{"EMFStore Project Files (*.ecm)", "All Files (*.*)"};
    private static final String IMPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.importModelPath";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedModelElement = UiUtil.getSelectedModelelement();
        final ECPProject project = ECPWorkspaceManager.getECPProject((EObject)selectedModelElement);
        if (project == null || selectedModelElement == null) {
            return null;
        }
        String fileName = this.getFileName();
        if (fileName == null) {
            return null;
        }
        final URI fileURI = URI.createFileURI((String)fileName);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        final Resource resource = resourceSet.getResource(fileURI, true);
        final ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        new ECPCommand(project.getRootObject()){

            protected void doRun() {
                ImportModelHandler.this.importFile(project, fileURI, resource, progressDialog);
            }
        }.run(false);
        return null;
    }

    private void importFile(ECPProject project, URI fileURI, Resource resource, ProgressMonitorDialog progressDialog) {
        try {
            try {
                progressDialog.open();
                progressDialog.getProgressMonitor().beginTask("Import model...", 100);
                Set<EObject> importElements = this.validation(resource);
                if (importElements.size() > 0) {
                    int i = 0;
                    for (EObject eObject : importElements) {
                        this.runImport(project, fileURI, EcoreUtil.copy((EObject)eObject), i);
                        progressDialog.getProgressMonitor().worked(10);
                        ++i;
                    }
                }
            }
            catch (RuntimeException e) {
                Activator.getDefault().logException(e.getMessage(), e);
                progressDialog.getProgressMonitor().done();
                progressDialog.close();
            }
        }
        finally {
            progressDialog.getProgressMonitor().done();
            progressDialog.close();
        }
    }

    private Set<EObject> validation(Resource resource) {
        HashSet<EObject> childrenSet = new HashSet<EObject>();
        HashSet<EObject> rootNodes = new HashSet<EObject>();
        EList rootContent = resource.getContents();
        for (EObject rootNode : rootContent) {
            TreeIterator contents = rootNode.eAllContents();
            while (contents.hasNext()) {
                EObject content = (EObject)contents.next();
                if (content == null) continue;
                childrenSet.add(content);
            }
        }
        for (EObject rootNode : rootContent) {
            if (rootNode == null || childrenSet.contains(rootNode)) continue;
            rootNodes.add(rootNode);
        }
        HashSet<EObject> notSelfContained = new HashSet<EObject>();
        for (EObject rootNode : rootNodes) {
            if (CommonUtil.isSelfContained((EObject)rootNode)) continue;
            notSelfContained.add(rootNode);
        }
        rootNodes.removeAll(notSelfContained);
        return rootNodes;
    }

    private String getFileName() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)IMPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File file = new File(dialog.getFilterPath(), dialog.getFileName());
        PreferenceHelper.setPreference((String)IMPORT_MODEL_PATH, (String)file.getParent());
        return file.getAbsolutePath();
    }

    private void runImport(ECPProject project, URI uri, EObject element, int resourceIndex) {
        project.addModelElementToRoot(element);
    }
}

