/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.model.util.IModelElementWrapperFactory;
import org.eclipse.emf.emfstore.client.model.util.WorkspaceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementWrapperDescriptor {
    private static final String EP_ID = "org.eclipse.emf.emfstore.client.wrapperfactories";
    private static final String NON_URI = "NON_URI";
    private static final String ATT_CLASS = "class";
    private static final String ATT_URI = "nsURI";
    private static final ModelElementWrapperDescriptor INSTANCE = new ModelElementWrapperDescriptor();
    private static Map<String, List<IModelElementWrapperFactory>> factoriesMap;

    public static ModelElementWrapperDescriptor getInstance() {
        return INSTANCE;
    }

    public static synchronized Map<String, List<IModelElementWrapperFactory>> getFactories() {
        if (factoriesMap != null) {
            return factoriesMap;
        }
        factoriesMap = new HashMap<String, List<IModelElementWrapperFactory>>();
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint(EP_ID).getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement configurationElement = configElements[j];
                try {
                    IModelElementWrapperFactory factory = (IModelElementWrapperFactory)configurationElement.createExecutableExtension(ATT_CLASS);
                    String nsURI = ModelElementWrapperDescriptor.getNsURI(configurationElement);
                    if (!factoriesMap.containsKey(nsURI)) {
                        factoriesMap.put(nsURI, new ArrayList());
                    }
                    List<IModelElementWrapperFactory> list = factoriesMap.get(nsURI);
                    list.add(factory);
                }
                catch (CoreException e) {
                    WorkspaceUtil.logException("Creating the wrapperfactories ", (Exception)((Object)e));
                }
                ++j;
            }
            ++i;
        }
        return factoriesMap;
    }

    private static String getNsURI(IConfigurationElement configurationElement) {
        String nsURI = configurationElement.getAttribute(ATT_URI);
        return nsURI != null ? nsURI : NON_URI;
    }

    public EObject wrap(EObject container, EObject toWrap) {
        this.ensureFactories();
        return this.wrap(container, toWrap, new DefaultWrapHelper());
    }

    public EObject wrapForImport(EObject container, EObject toWrap, URI resourceUri, int resourceIndex) {
        this.ensureFactories();
        return this.wrap(container, toWrap, new ImportWrapHelper(resourceUri, resourceIndex));
    }

    private void ensureFactories() {
        ModelElementWrapperDescriptor.getFactories();
    }

    private EObject wrap(EObject container, EObject toWrap, WrapHelper helper) {
        if (toWrap == null) {
            return null;
        }
        String nsURI = toWrap.eClass().getEPackage().getNsURI();
        if (factoriesMap.containsKey(nsURI)) {
            List<IModelElementWrapperFactory> factories = factoriesMap.get(nsURI);
            for (IModelElementWrapperFactory factory : factories) {
                EObject wrapped;
                if (!factory.isFor(container, toWrap) || (wrapped = helper.wrap(factory, container, toWrap)) == null) continue;
                return wrapped;
            }
        }
        return this.wrapWithoutNsURI(container, toWrap, helper);
    }

    private EObject wrapWithoutNsURI(EObject container, EObject toWrap, WrapHelper helper) {
        EObject wrapped = null;
        if (factoriesMap.containsKey(NON_URI)) {
            List<IModelElementWrapperFactory> factories = factoriesMap.get(NON_URI);
            for (IModelElementWrapperFactory factory : factories) {
                if (factory.isFor(container, toWrap) && (wrapped = helper.wrap(factory, container, toWrap)) != null) break;
            }
        }
        return wrapped;
    }

    private class DefaultWrapHelper
    implements WrapHelper {
        private DefaultWrapHelper() {
        }

        public EObject wrap(IModelElementWrapperFactory factory, EObject container, EObject toWrap) {
            return factory.wrap(toWrap);
        }
    }

    private final class ImportWrapHelper
    implements WrapHelper {
        private final URI uri;
        private final int resourceIndex;

        private ImportWrapHelper(URI uri, int resourceIndex) {
            this.uri = uri;
            this.resourceIndex = resourceIndex;
        }

        public EObject wrap(IModelElementWrapperFactory factory, EObject container, EObject toWrap) {
            return factory.wrapForImport(toWrap, this.uri, this.resourceIndex);
        }
    }

    private static interface WrapHelper {
        public EObject wrap(IModelElementWrapperFactory var1, EObject var2, EObject var3);
    }
}

