/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;

public abstract class ColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int DESC = -1;
    private int direction = 1;
    private ColumnLabelProvider columnLabelProvider;
    private final ColumnViewer viewer;
    private boolean sortingEnabled;

    public ColumnViewerSorter(ColumnViewer viewer, ColumnLabelProvider columnLabelProvider) {
        this.columnLabelProvider = columnLabelProvider;
        this.viewer = viewer;
    }

    protected void setSorter(ColumnViewerSorter sorter, int direction) {
        if (!this.sortingEnabled) {
            this.sortingEnabled = true;
        }
        this.direction = direction;
        if (this.viewer.getComparator() == sorter) {
            this.viewer.refresh();
        } else {
            this.viewer.setComparator((ViewerComparator)sorter);
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (!this.sortingEnabled) {
            return 0;
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        String str1 = this.columnLabelProvider.getText(e1);
        String str2 = this.columnLabelProvider.getText(e2);
        if (str1 == null) {
            str1 = "";
        }
        if (str2 == null) {
            str2 = "";
        }
        if ((str1.matches("[0-9]*") || str1.equals("")) && (str2.matches("[0-9]*") || str2.equals(""))) {
            return this.compareIntegers(str1, str2);
        }
        if (this.direction == 1) {
            return this.getComparator().compare(str1, str2);
        }
        return this.getComparator().compare(str2, str1);
    }

    private int compareIntegers(String str1, String str2) {
        int int2;
        int int1;
        if (str1.equals("")) {
            str1 = "0";
        }
        if (str2.equals("")) {
            str2 = "0";
        }
        try {
            int1 = Integer.parseInt(str1);
            int2 = Integer.parseInt(str2);
        }
        catch (NumberFormatException e) {
            return 0;
        }
        if (this.direction == 1) {
            return int1 - int2;
        }
        return int2 - int1;
    }

    public void setSortingEnabled(boolean sortingEnabled) {
        this.sortingEnabled = sortingEnabled;
    }

    public boolean isSortingEnabled() {
        return this.sortingEnabled;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getDirection() {
        return this.direction;
    }

    public abstract ViewerColumn getViewerColumn();

    public void setColumnLabelProvider(ColumnLabelProvider columnLabelProvider) {
        this.columnLabelProvider = columnLabelProvider;
    }

    public ColumnLabelProvider getColumnLabelProvider() {
        return this.columnLabelProvider;
    }

    public ColumnViewer getViewer() {
        return this.viewer;
    }
}

