/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.tupletable;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.NullIterator;
import org.apache.jena.atlas.iterator.SingletonIterator;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.tdb1.TDB1Exception;
import org.apache.jena.tdb1.base.record.Record;
import org.apache.jena.tdb1.base.record.RecordFactory;
import org.apache.jena.tdb1.index.RangeIndex;
import org.apache.jena.tdb1.lib.ColumnMap;
import org.apache.jena.tdb1.lib.TupleLib;
import org.apache.jena.tdb1.store.NodeId;
import org.apache.jena.tdb1.store.tupletable.TupleIndex;
import org.apache.jena.tdb1.store.tupletable.TupleIndexBase;

public class TupleIndexRecord
extends TupleIndexBase {
    private static final boolean Check = false;
    private RangeIndex index;
    private RecordFactory factory;

    public TupleIndexRecord(int N, ColumnMap colMapping, String name, RecordFactory factory, RangeIndex index) {
        super(N, colMapping, name);
        this.factory = factory;
        this.index = index;
        if (factory.keyLength() != N * 8) {
            throw new TDB1Exception(String.format("Mismatch: TupleIndex of length %d is not comparative with a factory for key length %d", N, factory.keyLength()));
        }
    }

    @Override
    protected boolean performAdd(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.add(r);
    }

    @Override
    protected boolean performDelete(Tuple<NodeId> tuple) {
        Record r = TupleLib.record(this.factory, tuple, this.colMap);
        return this.index.delete(r);
    }

    @Override
    protected Iterator<Tuple<NodeId>> performFind(Tuple<NodeId> pattern) {
        return this.findOrScan(pattern);
    }

    final Iterator<Tuple<NodeId>> findOrScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, true);
    }

    final Iterator<Tuple<NodeId>> findOrPartialScan(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, true, false);
    }

    final Iterator<Tuple<NodeId>> findByIndex(Tuple<NodeId> pattern) {
        return this.findWorker(pattern, false, false);
    }

    private Iterator<Tuple<NodeId>> findWorker(Tuple<NodeId> patternNaturalOrder, boolean partialScanAllowed, boolean fullScanAllowed) {
        NodeId X;
        Tuple<NodeId> pattern = this.colMap.map(patternNaturalOrder);
        int numSlots = 0;
        int leadingIdx = -2;
        boolean leading = true;
        Record minRec = this.factory.createKeyOnly();
        Record maxRec = this.factory.createKeyOnly();
        for (int i = 0; i < pattern.len(); ++i) {
            X = pattern.get(i);
            if (NodeId.isAny(X)) {
                X = null;
                leading = false;
                continue;
            }
            ++numSlots;
            if (!leading) continue;
            leadingIdx = i;
            Bytes.setLong(X.getId(), minRec.getKey(), i * 8);
            Bytes.setLong(X.getId(), maxRec.getKey(), i * 8);
        }
        if (numSlots == pattern.len()) {
            if (this.index.contains(minRec)) {
                return new SingletonIterator<Tuple<NodeId>>(pattern);
            }
            return new NullIterator<Tuple<NodeId>>();
        }
        Iterator<Record> iter = null;
        if (leadingIdx < 0) {
            if (!fullScanAllowed) {
                return null;
            }
            iter = this.index.iterator();
        } else {
            X = pattern.get(leadingIdx);
            Bytes.setLong(X.getId() + 1L, maxRec.getKey(), leadingIdx * 8);
            iter = this.index.iterator(minRec, maxRec);
        }
        Iterator<Tuple<NodeId>> tuples = Iter.map(iter, item -> TupleLib.tuple(item, this.colMap));
        if (leadingIdx < numSlots - 1) {
            if (!partialScanAllowed) {
                return null;
            }
            tuples = TupleIndex.scan(tuples, patternNaturalOrder);
        }
        return tuples;
    }

    @Override
    public Iterator<Tuple<NodeId>> all() {
        Iterator<Record> iter = this.index.iterator();
        return Iter.map(iter, item -> TupleLib.tuple(item, this.colMap));
    }

    @Override
    public void close() {
        this.index.close();
    }

    @Override
    public void sync() {
        this.index.sync();
    }

    public final RangeIndex getRangeIndex() {
        return this.index;
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }

    @Override
    public void clear() {
        this.index.clear();
    }

    @Override
    public long size() {
        return this.index.size();
    }
}

