/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.ClassNamePatternFilterUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.DefaultLauncher;
import org.junit.platform.launcher.core.DefaultLauncherSession;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;
import org.junit.platform.launcher.core.ListenerRegistry;
import org.junit.platform.launcher.core.ServiceLoaderRegistry;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.launcher.core.SessionPerRequestLauncher;

@API(status=API.Status.STABLE, since="1.0")
public class LauncherFactory {
    private LauncherFactory() {
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static LauncherSession openSession() throws PreconditionViolationException {
        return LauncherFactory.openSession(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static LauncherSession openSession(LauncherConfig config) throws PreconditionViolationException {
        Preconditions.notNull(config, "LauncherConfig must not be null");
        LauncherConfigurationParameters configurationParameters = LauncherConfigurationParameters.builder().build();
        return new DefaultLauncherSession(LauncherFactory.collectLauncherInterceptors(configurationParameters), () -> LauncherFactory.createLauncherSessionListener(config), () -> LauncherFactory.createDefaultLauncher(config, configurationParameters));
    }

    public static Launcher create() throws PreconditionViolationException {
        return LauncherFactory.create(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static Launcher create(LauncherConfig config) throws PreconditionViolationException {
        Preconditions.notNull(config, "LauncherConfig must not be null");
        LauncherConfigurationParameters configurationParameters = LauncherConfigurationParameters.builder().build();
        return new SessionPerRequestLauncher(() -> LauncherFactory.createDefaultLauncher(config, configurationParameters), () -> LauncherFactory.createLauncherSessionListener(config), () -> LauncherFactory.collectLauncherInterceptors(configurationParameters));
    }

    private static DefaultLauncher createDefaultLauncher(LauncherConfig config, LauncherConfigurationParameters configurationParameters) {
        Set<TestEngine> engines = LauncherFactory.collectTestEngines(config);
        List<PostDiscoveryFilter> filters = LauncherFactory.collectPostDiscoveryFilters(config);
        DefaultLauncher launcher = new DefaultLauncher(engines, filters);
        LauncherFactory.registerLauncherDiscoveryListeners(config, launcher);
        LauncherFactory.registerTestExecutionListeners(config, launcher, configurationParameters);
        return launcher;
    }

    private static List<LauncherInterceptor> collectLauncherInterceptors(LauncherConfigurationParameters configurationParameters) {
        if (configurationParameters.getBoolean("junit.platform.launcher.interceptors.enabled").orElse(false).booleanValue()) {
            ArrayList<LauncherInterceptor> interceptors = new ArrayList<LauncherInterceptor>();
            ServiceLoaderRegistry.load(LauncherInterceptor.class).forEach(interceptors::add);
            return interceptors;
        }
        return Collections.emptyList();
    }

    private static Set<TestEngine> collectTestEngines(LauncherConfig config) {
        LinkedHashSet<TestEngine> engines = new LinkedHashSet<TestEngine>();
        if (config.isTestEngineAutoRegistrationEnabled()) {
            new ServiceLoaderTestEngineRegistry().loadTestEngines().forEach(engines::add);
        }
        engines.addAll(config.getAdditionalTestEngines());
        return engines;
    }

    private static LauncherSessionListener createLauncherSessionListener(LauncherConfig config) {
        ListenerRegistry<LauncherSessionListener> listenerRegistry = ListenerRegistry.forLauncherSessionListeners();
        if (config.isLauncherSessionListenerAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(LauncherSessionListener.class).forEach(listenerRegistry::add);
        }
        config.getAdditionalLauncherSessionListeners().forEach(listenerRegistry::add);
        return listenerRegistry.getCompositeListener();
    }

    private static List<PostDiscoveryFilter> collectPostDiscoveryFilters(LauncherConfig config) {
        ArrayList<PostDiscoveryFilter> filters = new ArrayList<PostDiscoveryFilter>();
        if (config.isPostDiscoveryFilterAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(PostDiscoveryFilter.class).forEach(filters::add);
        }
        filters.addAll(config.getAdditionalPostDiscoveryFilters());
        return filters;
    }

    private static void registerLauncherDiscoveryListeners(LauncherConfig config, Launcher launcher) {
        if (config.isLauncherDiscoveryListenerAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(LauncherDiscoveryListener.class).forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
        }
        config.getAdditionalLauncherDiscoveryListeners().forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
    }

    private static void registerTestExecutionListeners(LauncherConfig config, Launcher launcher, LauncherConfigurationParameters configurationParameters) {
        if (config.isTestExecutionListenerAutoRegistrationEnabled()) {
            LauncherFactory.loadAndFilterTestExecutionListeners(configurationParameters).forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        }
        config.getAdditionalTestExecutionListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
    }

    private static Stream<TestExecutionListener> loadAndFilterTestExecutionListeners(ConfigurationParameters configurationParameters) {
        Iterable<TestExecutionListener> listeners = ServiceLoaderRegistry.load(TestExecutionListener.class);
        String deactivatedListenersPattern = configurationParameters.get("junit.platform.execution.listeners.deactivate").orElse(null);
        return StreamSupport.stream(listeners.spliterator(), false).filter(ClassNamePatternFilterUtils.excludeMatchingClasses(deactivatedListenersPattern));
    }
}

