/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.commands;

import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.provider.DefaultPositionProvider;
import org.eclipse.etrice.ui.structure.support.provider.SuperDiagramPositionProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

public class UpdateDiagramCommand
extends RecordingCommand {
    private Diagram diagram;
    private IFeatureProvider featureProvider;
    private StructureClass linkedSc;

    public UpdateDiagramCommand(Diagram diagram, TransactionalEditingDomain domain, IFeatureProvider featureProvider) {
        super(domain);
        this.diagram = diagram;
        this.featureProvider = featureProvider;
        this.linkedSc = null;
    }

    public UpdateDiagramCommand(Diagram diagram, StructureClass linkedSc, TransactionalEditingDomain domain, IFeatureProvider featureProvider) {
        this(diagram, domain, featureProvider);
        this.linkedSc = linkedSc;
    }

    protected void doExecute() {
        Object diagramBo;
        if (this.linkedSc != null) {
            this.featureProvider.link((PictogramElement)this.diagram, (Object)this.linkedSc);
        }
        UpdateContext context = (diagramBo = this.featureProvider.getBusinessObjectForPictogramElement((PictogramElement)this.diagram)) instanceof ActorClass && ((ActorClass)diagramBo).getBase() != null ? new PositionUpdateContext((PictogramElement)this.diagram, new SuperDiagramPositionProvider((StructureClass)((ActorClass)diagramBo))) : (diagramBo instanceof StructureClass && DiagramUtil.findScShape(this.diagram) == null ? new PositionUpdateContext((PictogramElement)this.diagram, new DefaultPositionProvider((StructureClass)diagramBo)) : new UpdateContext((PictogramElement)this.diagram));
        this.featureProvider.updateIfPossible((IUpdateContext)context);
    }

    public boolean updateNeeded() {
        return this.featureProvider.updateNeeded((IUpdateContext)new UpdateContext((PictogramElement)this.diagram)).toBoolean();
    }
}

